/*
 * Decompiled with CFR 0.152.
 */
package entities.units;

import art.Art;
import entities.projectiles.Missile;
import entities.projectiles.Projectile;
import entities.units.Unit;
import entities.units.UnitInfo;
import entities.units.unitOrders.UnitOrder;
import game.Game;
import game.Sprite3D;
import utils.Vec2;

public class MissileVehHeavy
extends Unit {
    public static final int BUILD_TIME = 1000;
    public static final int BUILD_COST = 1100;
    public static final int SIZE = 70;
    public static UnitInfo UNIT_INFO = new UnitInfo(1000, 1100, 70, Art.missileVehHeavy[0][0], Art.missileVehHeavy[1][0], "Diplomat", "Fires Large Missiles");

    public MissileVehHeavy(Game game, Vec2 vec2, int playerID, int unitID, UnitOrder[] startOrders) {
        super(game, vec2, playerID, unitID, startOrders);
        this.sprite = new boolean[2][][];
        this.sprite[0] = Sprite3D.spriteToArray(Art.missileVehHeavy[0][0]);
        this.sprite[1] = Sprite3D.spriteToArray(Art.missileVehHeavy[1][0]);
        this.canAttack = true;
        this.attackRange = 800.0;
        this.reloadTime = 500;
        this.initHealth(75);
        this.speed = 1.0;
        this.canMove = true;
        this.canMoveLand = true;
        this.canMoveWater = false;
        this.artStanding = false;
        this.rotationOffset = Math.toRadians(90.0);
        this.size = 70;
    }

    @Override
    protected Projectile newProjectile(Unit target) {
        return new Missile(this.myPlayerID, this.unitID, this.pos.clone(), this.game, target, Missile.MissileType.ICBM);
    }
}

