/*
 * Decompiled with CFR 0.152.
 */
package entities.units;

import art.Art;
import entities.projectiles.Grenade;
import entities.projectiles.Projectile;
import entities.units.Unit;
import entities.units.UnitInfo;
import entities.units.unitOrders.UnitOrder;
import game.Game;
import game.Sprite3D;
import utils.Vec2;

public class TankHeavy
extends Unit {
    public static final int BUILD_TIME = 1200;
    public static final int BUILD_COST = 800;
    public static final int SIZE = 80;
    public static UnitInfo UNIT_INFO = new UnitInfo(1200, 800, 80, Art.tankHeavy[0][0], Art.tankHeavy[1][0], "Bulldog", "Heavy Battle Tank");

    public TankHeavy(Game game, Vec2 vec2, int playerID, int unitID, UnitOrder[] startOrders) {
        super(game, vec2, playerID, unitID, startOrders);
        this.sprite = new boolean[2][][];
        this.sprite[0] = Sprite3D.spriteToArray(Art.tankHeavy[0][0]);
        this.sprite[1] = Sprite3D.spriteToArray(Art.tankHeavy[1][0]);
        this.canAttack = true;
        this.attackRange = 400.0;
        this.reloadTime = 200;
        this.initHealth(300);
        this.speed = 1.25;
        this.canMove = true;
        this.canMoveLand = true;
        this.canMoveWater = false;
        this.artStanding = false;
        this.rotationOffset = Math.toRadians(90.0);
        this.size = 80;
    }

    @Override
    protected Projectile newProjectile(Unit target) {
        return new Grenade(this.myPlayerID, this.unitID, this.pos.clone(), this.game, Grenade.GrenadeType.BULLDOG, target.pos.clone());
    }
}

