/*
 * Decompiled with CFR 0.152.
 */
package entities.units;

import entities.units.Builder;
import entities.units.CannonTower;
import entities.units.Factory1;
import entities.units.Factory2;
import entities.units.HoverHeavy;
import entities.units.HoverLight;
import entities.units.HoverMissile;
import entities.units.KbotFast;
import entities.units.KbotHeavy;
import entities.units.LaserTower;
import entities.units.MissileTower;
import entities.units.MissileVehHeavy;
import entities.units.MissileVehLight;
import entities.units.ResExtractor;
import entities.units.ResMakerL;
import entities.units.ResMakerM;
import entities.units.ResMakerS;
import entities.units.TankHeavy;
import entities.units.TankLight;
import entities.units.Unit;
import entities.units.UnitInfo;
import entities.units.unitOrders.UnitFactoryBuildOrder;
import entities.units.unitOrders.UnitOrder;
import game.Game;
import java.awt.image.BufferedImage;
import utils.Vec2;

public enum UnitType {
    BUILDER,
    FACTORY_1,
    FACTORY_2,
    RES_EXTRACTOR,
    RES_MAKER_S,
    RES_MAKER_M,
    RES_MAKER_L,
    MISSILE_TOWER,
    LASER_TOWER,
    CANNON_TOWER,
    KBOT_FAST,
    MISSILE_VEH_LIGHT,
    TANK_LIGHT,
    HOVER_LIGHT,
    TANK_HEAVY,
    KBOT_HEAVY,
    HOVER_MISSILE,
    HOVER_HEAVY,
    MISSILE_VEH_HEAVY;


    public static BufferedImage getBuildPic(UnitType t) {
        return UnitType.getUnitInfo((UnitType)t).buildPic;
    }

    public static int getBuildTime(UnitType t) {
        return UnitType.getUnitInfo((UnitType)t).buildTime;
    }

    public static int getBuildCost(UnitType t) {
        return UnitType.getUnitInfo((UnitType)t).buildCost;
    }

    public static int getSize(UnitType type) {
        return UnitType.getUnitInfo((UnitType)type).size;
    }

    public static String getName(UnitType type) {
        return UnitType.getUnitInfo((UnitType)type).name;
    }

    public static String getInfo(UnitType type) {
        return UnitType.getUnitInfo((UnitType)type).info;
    }

    private static UnitInfo getUnitInfo(UnitType type) {
        switch (type) {
            case BUILDER: {
                return Builder.UNIT_INFO;
            }
            case CANNON_TOWER: {
                return CannonTower.UNIT_INFO;
            }
            case FACTORY_1: {
                return Factory1.UNIT_INFO;
            }
            case FACTORY_2: {
                return Factory2.UNIT_INFO;
            }
            case HOVER_HEAVY: {
                return HoverHeavy.UNIT_INFO;
            }
            case HOVER_LIGHT: {
                return HoverLight.UNIT_INFO;
            }
            case HOVER_MISSILE: {
                return HoverMissile.UNIT_INFO;
            }
            case KBOT_FAST: {
                return KbotFast.UNIT_INFO;
            }
            case KBOT_HEAVY: {
                return KbotHeavy.UNIT_INFO;
            }
            case LASER_TOWER: {
                return LaserTower.UNIT_INFO;
            }
            case MISSILE_TOWER: {
                return MissileTower.UNIT_INFO;
            }
            case MISSILE_VEH_HEAVY: {
                return MissileVehHeavy.UNIT_INFO;
            }
            case MISSILE_VEH_LIGHT: {
                return MissileVehLight.UNIT_INFO;
            }
            case RES_EXTRACTOR: {
                return ResExtractor.UNIT_INFO;
            }
            case RES_MAKER_L: {
                return ResMakerL.UNIT_INFO;
            }
            case RES_MAKER_M: {
                return ResMakerM.UNIT_INFO;
            }
            case RES_MAKER_S: {
                return ResMakerS.UNIT_INFO;
            }
            case TANK_HEAVY: {
                return TankHeavy.UNIT_INFO;
            }
            case TANK_LIGHT: {
                return TankLight.UNIT_INFO;
            }
        }
        throw new IllegalArgumentException("Ok\u00e4nd UnitType: " + (Object)((Object)type));
    }

    public static Unit newUnit(UnitType unitType, Game game, Vec2 pos, int playerID, int unitID, UnitOrder[] startOrders) {
        switch (unitType) {
            case BUILDER: {
                return new Builder(game, pos, playerID, unitID, startOrders);
            }
            case CANNON_TOWER: {
                return new CannonTower(game, pos, playerID, unitID, startOrders);
            }
            case FACTORY_1: {
                UnitOrder[] newOrders1 = new UnitOrder[startOrders.length + 1];
                int i = 0;
                while (i < startOrders.length) {
                    newOrders1[i] = startOrders[i];
                    ++i;
                }
                newOrders1[newOrders1.length - 1] = new UnitFactoryBuildOrder();
                return new Factory1(game, pos, playerID, unitID, newOrders1);
            }
            case FACTORY_2: {
                UnitOrder[] newOrders2 = new UnitOrder[startOrders.length + 1];
                int i = 0;
                while (i < startOrders.length) {
                    newOrders2[i] = startOrders[i];
                    ++i;
                }
                newOrders2[newOrders2.length - 1] = new UnitFactoryBuildOrder();
                return new Factory2(game, pos, playerID, unitID, newOrders2);
            }
            case HOVER_HEAVY: {
                return new HoverHeavy(game, pos, playerID, unitID, startOrders);
            }
            case HOVER_LIGHT: {
                return new HoverLight(game, pos, playerID, unitID, startOrders);
            }
            case HOVER_MISSILE: {
                return new HoverMissile(game, pos, playerID, unitID, startOrders);
            }
            case KBOT_FAST: {
                return new KbotFast(game, pos, playerID, unitID, startOrders);
            }
            case KBOT_HEAVY: {
                return new KbotHeavy(game, pos, playerID, unitID, startOrders);
            }
            case LASER_TOWER: {
                return new LaserTower(game, pos, playerID, unitID, startOrders);
            }
            case MISSILE_TOWER: {
                return new MissileTower(game, pos, playerID, unitID, startOrders);
            }
            case MISSILE_VEH_HEAVY: {
                return new MissileVehHeavy(game, pos, playerID, unitID, startOrders);
            }
            case MISSILE_VEH_LIGHT: {
                return new MissileVehLight(game, pos, playerID, unitID, startOrders);
            }
            case RES_EXTRACTOR: {
                return new ResExtractor(game, pos, playerID, unitID, startOrders);
            }
            case RES_MAKER_L: {
                return new ResMakerL(game, pos, playerID, unitID, startOrders);
            }
            case RES_MAKER_M: {
                return new ResMakerM(game, pos, playerID, unitID, startOrders);
            }
            case RES_MAKER_S: {
                return new ResMakerS(game, pos, playerID, unitID, startOrders);
            }
            case TANK_HEAVY: {
                return new TankHeavy(game, pos, playerID, unitID, startOrders);
            }
            case TANK_LIGHT: {
                return new TankLight(game, pos, playerID, unitID, startOrders);
            }
        }
        throw new IllegalArgumentException("Ok\u00e4nd UnitType: " + (Object)((Object)unitType));
    }
}

