/*
 * Decompiled with CFR 0.152.
 */
package game;

import entities.projectiles.Projectile;
import entities.units.Unit;
import entities.units.UnitType;
import fonts.Fonts;
import game.B23Client;
import game.Game;
import game.Input;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JFrame;
import orders.FactoryBuildOrder;
import orders.FactoryRemoveBuildOrder;
import utils.Vec2;

public class Hud {
    Game game;
    JFrame frame;
    int topHeight = 100;
    int sideWidth = 100;
    int buildListX = 20;
    int buildListY = 150;
    int buildListSize = 50;
    int miniMapStart = 5;
    public static int MINIMAP_SIZE = 90;
    private int cost = -1;
    private int time = -1;
    private String name = null;
    private String info = null;
    private BufferedImage buildPic = null;

    public Hud(Game game, JFrame frame) {
        this.game = game;
        this.frame = frame;
    }

    public void draw(Graphics g) {
        int dy;
        int dx;
        Vec2 pos;
        g.setColor(new Color(0, 0, 0, 128));
        g.fillRect(0, this.topHeight, this.sideWidth, this.frame.getHeight() - this.topHeight);
        g.fillRect(0, 0, this.frame.getWidth(), this.topHeight);
        g.setColor(Color.black);
        g.drawRect(this.sideWidth, this.topHeight, this.frame.getWidth(), this.frame.getHeight());
        Font f = g.getFont();
        g.setFont(Fonts.c64size40);
        g.setColor(Color.black);
        g.drawString("RESOURCES:" + this.game.findPlayer((int)this.game.myPlayerID).resources + "+" + this.game.getResourceGain(this.game.myPlayerID), 204, 54);
        g.setColor(this.game.getPlayerColor(this.game.myPlayerID));
        g.drawString("RESOURCES:" + this.game.findPlayer((int)this.game.myPlayerID).resources + "+" + this.game.getResourceGain(this.game.myPlayerID), 200, 50);
        g.setFont(f);
        if (this.game.selectedUnits.size() == 1 && this.game.selectedUnits.get(0).canBuild()) {
            this.game.selectedUnits.get(0).drawBuildList(g, this.buildListX, this.buildListY, this.buildListSize);
        }
        g.drawImage(this.game.map.getMiniMapImage(), this.miniMapStart, this.miniMapStart, MINIMAP_SIZE, MINIMAP_SIZE, null);
        g.setColor(Color.black);
        g.drawRect(5, 5, MINIMAP_SIZE, MINIMAP_SIZE);
        if (this.cost != -1 && this.time != -1 && this.name != null && this.info != null && this.buildPic != null && this.posOnHud(this.game.input.getMousePoint())) {
            g.setColor(new Color(-2013265920, true));
            g.fillRect(this.sideWidth + 10, this.topHeight + 10, 220, 200);
            g.setColor(Color.black);
            g.drawRect(this.sideWidth + 10, this.topHeight + 10, 220, 200);
            g.setFont(Fonts.c64size12);
            g.setColor(Color.black);
            g.drawImage(this.buildPic, this.sideWidth + 10 + 50, this.topHeight + 10 + 80, 100, 100, null);
            g.drawRect(this.sideWidth + 10 + 50, this.topHeight + 10 + 80, 100, 100);
            g.drawString(this.name, this.sideWidth + 10 + 5 + 2, this.topHeight + 10 + 15 + 2);
            g.drawString(this.info, this.sideWidth + 10 + 5 + 2, this.topHeight + 10 + 15 + 15 + 2);
            g.drawString("COST: " + this.cost, this.sideWidth + 10 + 5 + 2, this.topHeight + 10 + 15 + 30 + 2);
            g.drawString("BUILD TIME: " + this.time, this.sideWidth + 10 + 5 + 2, this.topHeight + 10 + 15 + 45 + 2);
            g.setColor(B23Client.GUI_GREEN);
            g.drawString(this.name, this.sideWidth + 10 + 5, this.topHeight + 10 + 15);
            g.drawString(this.info, this.sideWidth + 10 + 5, this.topHeight + 10 + 15 + 15);
            g.drawString("COST: " + this.cost, this.sideWidth + 10 + 5, this.topHeight + 10 + 15 + 30);
            g.drawString("BUILD TIME: " + this.time, this.sideWidth + 10 + 5, this.topHeight + 10 + 15 + 45);
        }
        ArrayList<Unit> units = this.game.getUnits();
        int i = 0;
        while (i < units.size()) {
            Unit u = units.get(i);
            Color c = this.game.getPlayerColor(u.myPlayerID);
            g.setColor(c);
            pos = u.pos.clone();
            dx = (int)((double)MINIMAP_SIZE * pos.x / (double)this.game.map.getWidth());
            dy = (int)((double)MINIMAP_SIZE * pos.y / (double)this.game.map.getHeight());
            int hsize = 1;
            g.fillRect(this.miniMapStart + dx - hsize, this.miniMapStart + dy - hsize, hsize * 2, hsize * 2);
            g.setColor(Color.black);
            g.drawOval(this.miniMapStart + dx - hsize * 2, this.miniMapStart + dy - hsize * 2, hsize * 3, hsize * 3);
            ++i;
        }
        ArrayList<Projectile> projectiles = this.game.getProjectiles();
        int i2 = 0;
        while (i2 < projectiles.size()) {
            Projectile p = projectiles.get(i2);
            g.setColor(Color.yellow);
            pos = p.pos.clone();
            dx = (int)((double)MINIMAP_SIZE * pos.x / (double)this.game.map.getWidth());
            dy = (int)((double)MINIMAP_SIZE * pos.y / (double)this.game.map.getHeight());
            g.fillRect(this.miniMapStart + dx, this.miniMapStart + dy, 1, 1);
            ++i2;
        }
        Vec2 pos2 = this.game.camera.pos.clone();
        int dx2 = (int)((double)MINIMAP_SIZE * pos2.x / (double)this.game.map.getWidth());
        int dy2 = (int)((double)MINIMAP_SIZE * pos2.y / (double)this.game.map.getHeight());
        int w = MINIMAP_SIZE * this.frame.getWidth() / this.game.map.getWidth();
        int h = MINIMAP_SIZE * this.frame.getHeight() / this.game.map.getHeight();
        g.setColor(Color.yellow);
        g.drawRect(this.miniMapStart + dx2, this.miniMapStart + dy2, w, h);
    }

    public boolean posOnHud(Point mousePoint) {
        return mousePoint.x < this.sideWidth || mousePoint.y < this.topHeight;
    }

    public void handleMouseOnHud(Input input) {
        this.cost = -1;
        this.time = -1;
        this.name = null;
        this.info = null;
        this.buildPic = null;
        int mx = input.getMouseX();
        int my = input.getMouseY();
        if (input.isMouseDown() && mx >= this.miniMapStart && my >= this.miniMapStart && mx <= this.miniMapStart + MINIMAP_SIZE && my <= this.miniMapStart + MINIMAP_SIZE) {
            double perX = (double)(mx - this.miniMapStart) / (double)MINIMAP_SIZE;
            double perY = (double)(my - this.miniMapStart) / (double)MINIMAP_SIZE;
            this.game.camera.pos = new Vec2(perX * (double)this.game.map.getWidth(), perY * (double)this.game.map.getHeight());
        }
        if (mx >= this.buildListX && mx <= this.buildListX + this.buildListSize && my >= this.buildListY) {
            Unit u;
            UnitType t;
            int i = (my - this.buildListY) / this.buildListSize;
            if (this.game.selectedUnits.size() == 1 && this.game.selectedUnits.get(0).canBuild() && (t = (u = this.game.selectedUnits.get(0)).getBuilds(i)) != null) {
                this.cost = UnitType.getBuildCost(t);
                this.time = UnitType.getBuildTime(t);
                this.name = UnitType.getName(t);
                this.info = UnitType.getInfo(t);
                this.buildPic = UnitType.getBuildPic(t);
                if (input.isMouseLeftPressed()) {
                    if (u.factoryBuilder()) {
                        FactoryBuildOrder fbo = new FactoryBuildOrder();
                        fbo.buildListPos = i;
                        fbo.number = input.isKeyDown(input.SHIFT) ? 5 : 1;
                        fbo.unitID = this.game.selectedUnits.get((int)0).unitID;
                        this.game.addOrder(fbo);
                    } else {
                        this.game.currentBuildType = t;
                    }
                    this.game.effectHandler.newBuildMenuEffect(this.buildListX, this.buildListY + this.buildListSize * i, this.buildListSize);
                } else if (input.isMouseRightPressed() && u.factoryBuilder()) {
                    FactoryRemoveBuildOrder frbo = new FactoryRemoveBuildOrder();
                    frbo.buildListPos = i;
                    frbo.number = input.isKeyDown(input.SHIFT) ? 5 : 1;
                    frbo.unitID = this.game.selectedUnits.get((int)0).unitID;
                    this.game.addOrder(frbo);
                    this.game.effectHandler.newBuildMenuEffect(this.buildListX, this.buildListY + this.buildListSize * i, this.buildListSize);
                }
            }
        }
    }
}

