/*
 * Decompiled with CFR 0.152.
 */
package game;

import fonts.Fonts;
import game.B23Client;
import game.ChangeMapDialog;
import game.Input;
import game.InputDialog;
import game.Package;
import game.Settings;
import java.awt.Color;
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import javax.swing.JFrame;
import maps.MapInfo;

public class Lobby {
    boolean isHost;

    public String update(Package.ClientLobbyPackage myLatestLobbyPackage, Input input, String myName, int myPlayerID, boolean isHost, B23Client b23client, Package.LobbyPlayerServerPackage[] lobbyPlayers) {
        this.isHost = isHost;
        if (input.isKeyPressed(input.ENTER)) {
            String message = new InputDialog("Message:", "", b23client, b23client.getFrame(), input, 100, 450).get();
            if (message.equalsIgnoreCase("-rand")) {
                message = this.rand();
            } else if (message.equalsIgnoreCase("-debug_stats")) {
                Settings.DEBUG_GRAPHICS_STATS = true;
                Settings.DEBUG_SIMULATION_FPS_STATS = true;
                message = "[INFO] Graphics and Simulation time stats is on";
            } else if (message.equalsIgnoreCase("-debug_start")) {
                if (lobbyPlayers.length == 1) {
                    Settings.DEBUG_START_GAME_ONE_PLAYER = true;
                    message = "[INFO] Game can be started with only one player now";
                } else {
                    message = "[INFO] This option only works with one player";
                }
            } else if (message.equalsIgnoreCase("-help")) {
                message = "[INFO] Available commands: -rand -debug_stats -debug_start -help";
            }
            int length = myLatestLobbyPackage.chatMessages == null ? 1 : myLatestLobbyPackage.chatMessages.length + 1;
            Package.ChatMessage[] newArr = new Package.ChatMessage[length];
            int i = 0;
            while (myLatestLobbyPackage.chatMessages != null && i < myLatestLobbyPackage.chatMessages.length) {
                newArr[i] = myLatestLobbyPackage.chatMessages[i];
                ++i;
            }
            newArr[newArr.length - 1] = new Package.ChatMessage();
            newArr[newArr.length - 1].message = message;
            newArr[newArr.length - 1].playerID = myPlayerID;
            myLatestLobbyPackage.chatMessages = newArr;
        }
        if (input.isKeyPressed(input.M) && isHost) {
            myLatestLobbyPackage.map = new ChangeMapDialog(50, 50, b23client, input).get();
        }
        if (isHost && input.isKeyPressed(input.S)) {
            Package.ChatMessage cm;
            if (this.allReady(lobbyPlayers)) {
                if (!Settings.DEBUG_START_GAME_ONE_PLAYER && lobbyPlayers.length == 1) {
                    myLatestLobbyPackage.start = false;
                    cm = new Package.ChatMessage();
                    cm.message = "[INFO] Cannot start the game with only one player!";
                    cm.playerID = myPlayerID;
                    b23client.chatMessages.add(cm);
                } else {
                    myLatestLobbyPackage.start = true;
                }
            } else {
                myLatestLobbyPackage.start = false;
                cm = new Package.ChatMessage();
                cm.message = "[INFO] Cannot start the game until all players are ready!";
                cm.playerID = myPlayerID;
                b23client.chatMessages.add(cm);
            }
        }
        myLatestLobbyPackage.changeColor = input.isKeyPressed(input.C);
        myLatestLobbyPackage.changeReady = input.isKeyPressed(input.R);
        myLatestLobbyPackage.changeTeam = input.isKeyPressed(input.T);
        myLatestLobbyPackage.newName = input.isKeyPressed(input.N) ? new InputDialog("New name:", "", b23client, b23client.getFrame(), input, 100, 450).get() : myName;
        myName = myLatestLobbyPackage.newName;
        return myName;
    }

    private String rand() {
        String m = "";
        try {
            URL url = new URL("http://en.wikipedia.org/wiki/Special:Random");
            URLConnection conn = url.openConnection();
            DataInputStream in = new DataInputStream(conn.getInputStream());
            BufferedReader d = new BufferedReader(new InputStreamReader(in));
            d.readLine();
            d.readLine();
            d.readLine();
            m = d.readLine();
            m = m.substring(7, m.length() - 43);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return m;
    }

    private boolean allReady(Package.LobbyPlayerServerPackage[] lobbyPlayers) {
        int i = 0;
        while (i < lobbyPlayers.length) {
            if (!lobbyPlayers[i].ready) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void draw(Graphics g, Package.LobbyPlayerServerPackage[] lobbyPlayers, ArrayList<Package.ChatMessage> chatMessages, B23Client b23client, JFrame frame, int port, String ip) {
        g.setColor(B23Client.GUI_PURPLE);
        g.fillRect(0, 0, frame.getWidth(), frame.getHeight());
        g.setFont(Fonts.c64size20);
        if (lobbyPlayers != null) {
            int i = 0;
            while (i < lobbyPlayers.length) {
                Package.LobbyPlayerServerPackage lp = lobbyPlayers[i];
                g.setColor(Color.black);
                g.drawString(String.valueOf(lp.name) + " " + (lp.ready ? "[READY]" : "[NOT READY]"), 102, 100 + 30 * i + 2);
                g.setColor(new Color(lp.color));
                g.drawString(String.valueOf(lp.name) + " " + (lp.ready ? "[READY]" : "[NOT READY]"), 100, 100 + 30 * i);
                ++i;
            }
        }
        g.setColor(Color.black);
        int ix = 700;
        int iy = 130;
        int dy = 30;
        g.drawString("IP: " + ip, ix + 3, iy - dy * 3 + 3);
        g.drawString("Port: " + port, ix + 3, iy - dy * 2 + 3);
        g.drawString("Keys:", ix + 3, iy + 3);
        g.drawString("ENTER - type message", ix + 3, iy + dy * 1 + 3);
        g.drawString("N - change name", ix + 3, iy + dy * 2 + 3);
        g.drawString("C - change color", ix + 3, iy + dy * 3 + 3);
        g.drawString("R - ready", ix + 3, iy + dy * 4 + 3);
        if (this.isHost) {
            g.drawString("M - change map", ix + 3, iy + dy * 5 + 3);
            g.drawString("S - start", ix + 3, iy + dy * 6 + 3);
        }
        g.setColor(B23Client.GUI_GREEN);
        g.drawString("IP: " + ip, ix, iy - dy * 3);
        g.drawString("Port: " + port, ix, iy - dy * 2);
        g.drawString("Keys:", ix, iy);
        g.drawString("ENTER - type message", ix, iy + dy * 1);
        g.drawString("N - change name", ix, iy + dy * 2);
        g.drawString("C - change color", ix, iy + dy * 3);
        g.drawString("R - ready", ix, iy + dy * 4);
        if (this.isHost) {
            g.drawString("M - change map", ix, iy + dy * 5);
            g.drawString("S - start", ix, iy + dy * 6);
        }
        g.setColor(Color.black);
        g.drawString("CurrentMap: " + MapInfo.getMapName(MapInfo.MAPS[b23client.map]) + " " + MapInfo.getMapPlayers(MapInfo.MAPS[b23client.map]) + " Players", 103, 453);
        g.setColor(B23Client.GUI_GREEN);
        g.drawString("CurrentMap: " + MapInfo.getMapName(MapInfo.MAPS[b23client.map]) + " " + MapInfo.getMapPlayers(MapInfo.MAPS[b23client.map]) + " Players", 100, 450);
        g.fill3DRect(100, 500, frame.getWidth(), frame.getHeight(), true);
        int i = chatMessages.size() - 1;
        while (i >= 0) {
            g.setColor(Color.black);
            g.drawString(String.valueOf(b23client.getPlayerName(chatMessages.get((int)(chatMessages.size() - 1 - i)).playerID)) + ": " + chatMessages.get((int)(chatMessages.size() - 1 - i)).message, 132, 530 + i * 30 + 2);
            g.setColor(B23Client.GUI_PURPLE);
            g.drawString(String.valueOf(b23client.getPlayerName(chatMessages.get((int)(chatMessages.size() - 1 - i)).playerID)) + ": " + chatMessages.get((int)(chatMessages.size() - 1 - i)).message, 130, 530 + i * 30);
            --i;
        }
    }
}

