/*
 * Decompiled with CFR 0.152.
 */
package game;

import art.Art;
import fonts.Fonts;
import game.B23Client;
import game.Input;
import game.Sprite3D;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JFrame;
import sound.Sound;
import utils.Vec2;

public class MainMenu {
    Input input;
    JFrame frame;
    Sound sound;
    int pos = 0;
    String[] actions = new String[]{"JOIN", "HOST", "EXIT"};
    double rot;

    public MainMenu(Input input, JFrame frame, Sound sound) {
        this.input = input;
        this.frame = frame;
        this.sound = sound;
    }

    public Action update() {
        Action action;
        block18: {
            block17: {
                action = Action.NO_ACTION;
                if (this.input.isKeyPressed(this.input.J)) {
                    action = Action.JOIN_GAME;
                }
                if (this.input.isKeyPressed(this.input.H)) {
                    action = Action.HOST_GAME;
                }
                if (this.input.isKeyPressed(this.input.E)) {
                    action = Action.EXIT;
                }
                this.input.getClass();
                if (this.input.isKeyPressed(40)) {
                    ++this.pos;
                    if (this.pos == this.actions.length) {
                        this.pos = 0;
                    }
                    this.sound.playSound(Sound.CLICK);
                }
                this.input.getClass();
                if (this.input.isKeyPressed(38)) {
                    --this.pos;
                    if (this.pos == -1) {
                        this.pos = this.actions.length - 1;
                    }
                    this.sound.playSound(Sound.CLICK);
                }
                if (this.input.isKeyPressed(this.input.ENTER)) break block17;
                this.input.getClass();
                if (!this.input.isKeyPressed(32)) break block18;
            }
            if (this.pos == 0) {
                action = Action.JOIN_GAME;
            } else if (this.pos == 1) {
                action = Action.HOST_GAME;
            } else if (this.pos == 2) {
                action = Action.EXIT;
            }
        }
        this.rot += 0.01;
        try {
            Thread.sleep(20L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return action;
    }

    public void draw(Graphics g) {
        g.setColor(B23Client.GUI_PURPLE);
        g.fillRect(0, 0, this.frame.getWidth(), this.frame.getHeight());
        g.setColor(Color.red);
        Sprite3D.drawStanding(g, Sprite3D.spriteToArray(Art.builder), Color.red, new Vec2(this.frame.getWidth() / 2, this.frame.getHeight() / 2 + 300), 800.0, this.rot, true);
        Sprite3D.drawStanding(g, Sprite3D.spriteToArray(Art.builder), Color.red.darker(), new Vec2(this.frame.getWidth() / 2, this.frame.getHeight() / 2 + 300), 800.0, this.rot, false);
        g.setColor(B23Client.GUI_GREEN);
        int i = 0;
        while (i < this.actions.length) {
            if (this.pos == i) {
                g.setFont(Fonts.c64size120);
                g.translate(-30, -20);
            } else {
                g.setFont(Fonts.c64size100);
            }
            g.setColor(Color.BLACK);
            g.drawString(this.actions[i], this.frame.getWidth() / 2 - 120 + 10, this.frame.getHeight() / 2 - 200 + i * 200 + 10);
            g.setColor(B23Client.GUI_GREEN);
            g.drawString(this.actions[i], this.frame.getWidth() / 2 - 120, this.frame.getHeight() / 2 - 200 + i * 200);
            if (this.pos == i) {
                g.translate(30, 20);
            }
            ++i;
        }
    }

    public static enum Action {
        NO_ACTION,
        JOIN_GAME,
        HOST_GAME,
        EXIT;

    }
}

