/*
 * Decompiled with CFR 0.152.
 */
package game;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.image.BufferedImage;
import utils.Vec2;

public class Sprite3D {
    static double xzAngle = Math.toRadians(35.264);
    static double yAngle = 0.0;
    static double boxSiz = 10.0;
    static double d = 2.0;

    public static boolean[][] spriteToArray(BufferedImage bi) {
        boolean[][] sprite = new boolean[bi.getWidth()][bi.getHeight()];
        int i = 0;
        while (i < sprite.length) {
            int j = 0;
            while (j < sprite[i].length) {
                int col = bi.getRGB(i, j);
                sprite[i][j] = col != -1;
                ++j;
            }
            ++i;
        }
        return sprite;
    }

    private static double d(double a, double b) {
        return a - b;
    }

    private static Point transform(double x, double y, double z) {
        int tx = (int)(Math.cos(xzAngle) * x - Math.sin(yAngle) * z);
        int ty = (int)(Math.sin(xzAngle) * Math.sin(yAngle) * x + Math.cos(xzAngle) * y + Math.sin(xzAngle) * Math.cos(yAngle) * z);
        return new Point(tx, ty);
    }

    public static void drawGround(Graphics g, boolean[][] sprite, Color color, Vec2 pos, double size, double xzRot, boolean fill) {
        g.setColor(color);
        int ix = 0;
        while (ix < sprite.length) {
            int iy = 0;
            while (iy < sprite[ix].length) {
                if (sprite[ix][iy]) {
                    Point[] points = new Point[8];
                    CubeCorner[] cc = new CubeCorner[]{new CubeCorner(0, 0, 0), new CubeCorner(1, 0, 0), new CubeCorner(1, 0, 1), new CubeCorner(0, 0, 1), new CubeCorner(0, 1, 0), new CubeCorner(1, 1, 0), new CubeCorner(1, 1, 1), new CubeCorner(0, 1, 1)};
                    int i = 0;
                    while (i < cc.length) {
                        Point p;
                        CubeCorner c = cc[i];
                        double side = size / (double)sprite.length;
                        double dx = side * ((double)ix - (double)sprite.length / 2.0) + (c.left ? side : 0.0);
                        double dy = c.front ? side / 2.0 : -side / 2.0;
                        double dz = side * ((double)iy - (double)sprite[0].length / 2.0) + (c.down ? 0.0 : side);
                        double cos = Math.cos(xzRot);
                        double sin = Math.sin(xzRot);
                        double x = cos * dx - sin * dz;
                        double y = dy;
                        double z = sin * dx + cos * dz;
                        points[i] = p = Sprite3D.transform(x, y, z);
                        ++i;
                    }
                    Point p000 = points[0];
                    Point p100 = points[1];
                    Point p101 = points[2];
                    Point p001 = points[3];
                    Point p010 = points[4];
                    Point p110 = points[5];
                    Point p111 = points[6];
                    Point p011 = points[7];
                    Point[] pointArray = points;
                    int cos = points.length;
                    int n = 0;
                    while (n < cos) {
                        Point p = pointArray[n];
                        p.translate((int)pos.x, (int)pos.y);
                        ++n;
                    }
                    Polygon top = new Polygon();
                    top.addPoint(p010.x, p010.y);
                    top.addPoint(p110.x, p110.y);
                    top.addPoint(p111.x, p111.y);
                    top.addPoint(p011.x, p011.y);
                    Polygon front = new Polygon();
                    front.addPoint(p000.x, p000.y);
                    front.addPoint(p100.x, p100.y);
                    front.addPoint(p110.x, p110.y);
                    front.addPoint(p010.x, p010.y);
                    Polygon back = new Polygon();
                    back.addPoint(p001.x, p001.y);
                    back.addPoint(p101.x, p101.y);
                    back.addPoint(p111.x, p111.y);
                    back.addPoint(p011.x, p011.y);
                    Polygon left = new Polygon();
                    left.addPoint(p000.x, p000.y);
                    left.addPoint(p010.x, p010.y);
                    left.addPoint(p011.x, p011.y);
                    left.addPoint(p001.x, p001.y);
                    Polygon bot = new Polygon();
                    bot.addPoint(p000.x, p000.y);
                    bot.addPoint(p100.x, p100.y);
                    bot.addPoint(p101.x, p101.y);
                    bot.addPoint(p001.x, p001.y);
                    Polygon right = new Polygon();
                    right.addPoint(p100.x, p100.y);
                    right.addPoint(p110.x, p110.y);
                    right.addPoint(p111.x, p111.y);
                    right.addPoint(p101.x, p101.y);
                    if (fill) {
                        g.fillPolygon(top);
                        g.fillPolygon(bot);
                        g.fillPolygon(front);
                        g.fillPolygon(back);
                        g.fillPolygon(left);
                        g.fillPolygon(right);
                    } else {
                        g.drawPolygon(top);
                        g.drawPolygon(bot);
                        g.drawPolygon(front);
                        g.drawPolygon(back);
                        g.drawPolygon(left);
                        g.drawPolygon(right);
                    }
                }
                ++iy;
            }
            ++ix;
        }
    }

    public static void drawStanding(Graphics g, boolean[][] sprite, Color color, Vec2 pos, double size, double xzRot, boolean fill) {
        g.setColor(color);
        int ix = 0;
        while (ix < sprite.length) {
            int iy = 0;
            while (iy < sprite[ix].length) {
                if (sprite[ix][iy]) {
                    Point[] points = new Point[8];
                    CubeCorner[] cc = new CubeCorner[]{new CubeCorner(0, 0, 0), new CubeCorner(1, 0, 0), new CubeCorner(1, 0, 1), new CubeCorner(0, 0, 1), new CubeCorner(0, 1, 0), new CubeCorner(1, 1, 0), new CubeCorner(1, 1, 1), new CubeCorner(0, 1, 1)};
                    int i = 0;
                    while (i < cc.length) {
                        Point p;
                        CubeCorner c = cc[i];
                        double side = size / (double)sprite.length;
                        double dx = side * ((double)ix - (double)sprite.length / 2.0) + (c.left ? side : 0.0);
                        double dy = side * (double)(iy - sprite[0].length) + (c.down ? 0.0 : side);
                        double dz = c.front ? side / 2.0 : -side / 2.0;
                        double cos = Math.cos(xzRot);
                        double sin = Math.sin(xzRot);
                        double x = cos * dx - sin * dz;
                        double y = dy;
                        double z = sin * dx + cos * dz;
                        points[i] = p = Sprite3D.transform(x, y, z);
                        ++i;
                    }
                    Point p000 = points[0];
                    Point p100 = points[1];
                    Point p101 = points[2];
                    Point p001 = points[3];
                    Point p010 = points[4];
                    Point p110 = points[5];
                    Point p111 = points[6];
                    Point p011 = points[7];
                    Point[] pointArray = points;
                    int cos = points.length;
                    int n = 0;
                    while (n < cos) {
                        Point p = pointArray[n];
                        p.translate((int)pos.x, (int)pos.y);
                        ++n;
                    }
                    Polygon top = new Polygon();
                    top.addPoint(p010.x, p010.y);
                    top.addPoint(p110.x, p110.y);
                    top.addPoint(p111.x, p111.y);
                    top.addPoint(p011.x, p011.y);
                    Polygon front = new Polygon();
                    front.addPoint(p000.x, p000.y);
                    front.addPoint(p100.x, p100.y);
                    front.addPoint(p110.x, p110.y);
                    front.addPoint(p010.x, p010.y);
                    Polygon back = new Polygon();
                    back.addPoint(p001.x, p001.y);
                    back.addPoint(p101.x, p101.y);
                    back.addPoint(p111.x, p111.y);
                    back.addPoint(p011.x, p011.y);
                    Polygon left = new Polygon();
                    left.addPoint(p000.x, p000.y);
                    left.addPoint(p010.x, p010.y);
                    left.addPoint(p011.x, p011.y);
                    left.addPoint(p001.x, p001.y);
                    Polygon bot = new Polygon();
                    bot.addPoint(p000.x, p000.y);
                    bot.addPoint(p100.x, p100.y);
                    bot.addPoint(p101.x, p101.y);
                    bot.addPoint(p001.x, p001.y);
                    Polygon right = new Polygon();
                    right.addPoint(p100.x, p100.y);
                    right.addPoint(p110.x, p110.y);
                    right.addPoint(p111.x, p111.y);
                    right.addPoint(p101.x, p101.y);
                    if (fill) {
                        g.fillPolygon(top);
                        g.fillPolygon(bot);
                        g.fillPolygon(front);
                        g.fillPolygon(back);
                        g.fillPolygon(left);
                        g.fillPolygon(right);
                    } else {
                        g.drawPolygon(top);
                        g.drawPolygon(bot);
                        g.drawPolygon(front);
                        g.drawPolygon(back);
                        g.drawPolygon(left);
                        g.drawPolygon(right);
                    }
                }
                ++iy;
            }
            ++ix;
        }
    }

    public static void draw3(Graphics g, boolean[][] sprite, Color color, Vec2 pos, double size, double xzRot, double yRot) {
        g.setColor(color);
        int ix = 0;
        while (ix < sprite.length) {
            int iy = 0;
            while (iy < sprite[ix].length) {
                if (sprite[ix][iy]) {
                    double cx = size * (double)sprite.length / 2.0;
                    double cy = size * (double)sprite[0].length / 2.0;
                    double s = Math.sin(xzRot);
                    double c = Math.cos(xzRot);
                    double x = (double)ix * size;
                    double y = (double)iy * size;
                    Point p000 = Sprite3D.transform(x + 0.0, y + 0.0, 0.0);
                    Point p100 = Sprite3D.transform(x + size, y + 0.0, 0.0);
                    Point p101 = Sprite3D.transform(x + size, y + 0.0, size);
                    Point p001 = Sprite3D.transform(x + 0.0, y + 0.0, size);
                    Point p010 = Sprite3D.transform(x + 0.0, y + size, 0.0);
                    Point p110 = Sprite3D.transform(x + size, y + size, 0.0);
                    Point p111 = Sprite3D.transform(x + size, y + size, size);
                    Point p011 = Sprite3D.transform(x + 0.0, y + size, size);
                    p000.translate((int)pos.x, (int)pos.y);
                    p100.translate((int)pos.x, (int)pos.y);
                    p101.translate((int)pos.x, (int)pos.y);
                    p001.translate((int)pos.x, (int)pos.y);
                    p010.translate((int)pos.x, (int)pos.y);
                    p110.translate((int)pos.x, (int)pos.y);
                    p111.translate((int)pos.x, (int)pos.y);
                    p011.translate((int)pos.x, (int)pos.y);
                    Polygon top = new Polygon();
                    top.addPoint(p010.x, p010.y);
                    top.addPoint(p110.x, p110.y);
                    top.addPoint(p111.x, p111.y);
                    top.addPoint(p011.x, p011.y);
                    Polygon front = new Polygon();
                    front.addPoint(p000.x, p000.y);
                    front.addPoint(p100.x, p100.y);
                    front.addPoint(p110.x, p110.y);
                    front.addPoint(p010.x, p010.y);
                    Polygon back = new Polygon();
                    back.addPoint(p001.x, p001.y);
                    back.addPoint(p101.x, p101.y);
                    back.addPoint(p111.x, p111.y);
                    back.addPoint(p011.x, p011.y);
                    Polygon left = new Polygon();
                    left.addPoint(p000.x, p000.y);
                    left.addPoint(p010.x, p010.y);
                    left.addPoint(p011.x, p011.y);
                    left.addPoint(p001.x, p001.y);
                    Polygon bot = new Polygon();
                    bot.addPoint(p000.x, p000.y);
                    bot.addPoint(p100.x, p100.y);
                    bot.addPoint(p101.x, p101.y);
                    bot.addPoint(p001.x, p001.y);
                    Polygon right = new Polygon();
                    right.addPoint(p100.x, p100.y);
                    right.addPoint(p110.x, p110.y);
                    right.addPoint(p111.x, p111.y);
                    right.addPoint(p101.x, p101.y);
                    g.fillPolygon(top);
                    g.fillPolygon(bot);
                    g.fillPolygon(front);
                    g.fillPolygon(back);
                    g.fillPolygon(left);
                    g.fillPolygon(right);
                }
                ++iy;
            }
            ++ix;
        }
    }

    private static void drawSprite2(Graphics g, boolean[][] sprite) {
        int y;
        int x = 0;
        while (x < sprite.length) {
            y = 0;
            while (y < sprite[x].length) {
                if (sprite[x][y]) {
                    g.setColor(Color.red.darker());
                    Sprite3D.fillCube2(g, boxSiz * (double)x - d, boxSiz * (double)y - d, boxSiz + d * 2.0);
                }
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < sprite.length) {
            y = 0;
            while (y < sprite[x].length) {
                if (sprite[x][y]) {
                    g.setColor(Color.red);
                    Sprite3D.fillCube2(g, boxSiz * (double)x, boxSiz * (double)y, boxSiz);
                }
                ++y;
            }
            ++x;
        }
        g.setColor(Color.black);
        x = 0;
        while (x < sprite.length) {
            y = 0;
            while (y < sprite[x].length) {
                boolean cfr_ignored_0 = sprite[x][y];
                ++y;
            }
            ++x;
        }
    }

    private static void fillCube2(Graphics g, double x, double y, double boxSize) {
        Point p000 = Sprite3D.transform(x + 0.0, y + 0.0, 0.0);
        Point p100 = Sprite3D.transform(x + boxSize, y + 0.0, 0.0);
        Point p101 = Sprite3D.transform(x + boxSize, y + 0.0, boxSize);
        Point p001 = Sprite3D.transform(x + 0.0, y + 0.0, boxSize);
        Point p010 = Sprite3D.transform(x + 0.0, y + boxSize, 0.0);
        Point p110 = Sprite3D.transform(x + boxSize, y + boxSize, 0.0);
        Point p111 = Sprite3D.transform(x + boxSize, y + boxSize, boxSize);
        Point p011 = Sprite3D.transform(x + 0.0, y + boxSize, boxSize);
        Polygon top = new Polygon();
        top.addPoint(p010.x, p010.y);
        top.addPoint(p110.x, p110.y);
        top.addPoint(p111.x, p111.y);
        top.addPoint(p011.x, p011.y);
        Polygon front = new Polygon();
        front.addPoint(p000.x, p000.y);
        front.addPoint(p100.x, p100.y);
        front.addPoint(p110.x, p110.y);
        front.addPoint(p010.x, p010.y);
        Polygon back = new Polygon();
        back.addPoint(p001.x, p001.y);
        back.addPoint(p101.x, p101.y);
        back.addPoint(p111.x, p111.y);
        back.addPoint(p011.x, p011.y);
        Polygon left = new Polygon();
        left.addPoint(p000.x, p000.y);
        left.addPoint(p010.x, p010.y);
        left.addPoint(p011.x, p011.y);
        left.addPoint(p001.x, p001.y);
        Polygon bot = new Polygon();
        bot.addPoint(p000.x, p000.y);
        bot.addPoint(p100.x, p100.y);
        bot.addPoint(p101.x, p101.y);
        bot.addPoint(p001.x, p001.y);
        Polygon right = new Polygon();
        right.addPoint(p100.x, p100.y);
        right.addPoint(p110.x, p110.y);
        right.addPoint(p111.x, p111.y);
        right.addPoint(p101.x, p101.y);
        g.fillPolygon(top);
        g.fillPolygon(bot);
        g.fillPolygon(front);
        g.fillPolygon(back);
        g.fillPolygon(left);
        g.fillPolygon(right);
    }

    private static class CubeCorner {
        boolean front;
        boolean down;
        boolean left;

        public CubeCorner(int front, int down, int left) {
            this.front = front == 1;
            this.down = down == 1;
            this.left = left == 1;
        }
    }
}

