/*
 * Decompiled with CFR 0.152.
 */
package maps;

import art.Art;
import game.Game;
import java.awt.Image;
import maps.B23Map;
import maps.CenterConflict;
import maps.CostalChaos;
import maps.FourFingers;
import maps.IceLake;
import maps.ScorchedEarth;
import maps.TheBridge;
import maps.TheSixthSense;

public class MapInfo {
    public static final MapType[] MAPS = new MapType[]{MapType.CENTER_CONFLICT, MapType.COSTAL_CHAOS, MapType.FOUR_FINGERS, MapType.ICE_LAKE, MapType.SCORCHED_EARTH, MapType.THE_BRIDGE, MapType.THE_SIXTH_SENSE};

    public static String getMapName(MapType m) {
        switch (m) {
            case CENTER_CONFLICT: {
                return "Center Conflict";
            }
            case COSTAL_CHAOS: {
                return "Costal Chaos";
            }
            case SCORCHED_EARTH: {
                return "Scorched Earth";
            }
            case THE_BRIDGE: {
                return "The Bridge";
            }
            case ICE_LAKE: {
                return "Ice Lake";
            }
            case THE_SIXTH_SENSE: {
                return "The Sixth Sense";
            }
            case FOUR_FINGERS: {
                return "Four Fingers";
            }
        }
        return null;
    }

    public static Image getMapImage(MapType m) {
        switch (m) {
            case CENTER_CONFLICT: {
                return Art.centerConflict;
            }
            case COSTAL_CHAOS: {
                return Art.costalChaos;
            }
            case SCORCHED_EARTH: {
                return Art.scorchedEarth;
            }
            case THE_BRIDGE: {
                return Art.theBridge;
            }
            case ICE_LAKE: {
                return Art.iceLake;
            }
            case THE_SIXTH_SENSE: {
                return Art.theSixthSense;
            }
            case FOUR_FINGERS: {
                return Art.fourFingers;
            }
        }
        return null;
    }

    public static B23Map createMap(int mapNumber, Game game) {
        switch (MAPS[mapNumber]) {
            case CENTER_CONFLICT: {
                return new CenterConflict(game);
            }
            case COSTAL_CHAOS: {
                return new CostalChaos(game);
            }
            case SCORCHED_EARTH: {
                return new ScorchedEarth(game);
            }
            case THE_BRIDGE: {
                return new TheBridge(game);
            }
            case ICE_LAKE: {
                return new IceLake(game);
            }
            case THE_SIXTH_SENSE: {
                return new TheSixthSense(game);
            }
            case FOUR_FINGERS: {
                return new FourFingers(game);
            }
        }
        return null;
    }

    public static int getMapPlayers(MapType mapType) {
        switch (mapType) {
            case CENTER_CONFLICT: {
                return 2;
            }
            case COSTAL_CHAOS: {
                return 2;
            }
            case SCORCHED_EARTH: {
                return 4;
            }
            case THE_BRIDGE: {
                return 2;
            }
            case ICE_LAKE: {
                return 4;
            }
            case THE_SIXTH_SENSE: {
                return 6;
            }
            case FOUR_FINGERS: {
                return 4;
            }
        }
        return -1;
    }

    public static enum MapType {
        CENTER_CONFLICT,
        COSTAL_CHAOS,
        SCORCHED_EARTH,
        THE_BRIDGE,
        ICE_LAKE,
        THE_SIXTH_SENSE,
        FOUR_FINGERS;

    }
}

