# -*- coding: cp1252 -*-
'''
Created on 22 aug 2012

@author: Dan Torberg

Modul innehllande klassen Player samt subklasserna Player1 och Player2.

Basklassens variabler:

Xspeed         representerar spelarens hastighet i X-led.
Yspeed         representerar spelaren hastighet i Y-led.
weapon         representerar vapent som spelaren fr tillflligt anvnder.
shotgun_found  stts till true om spelaren har hittat en shotgun.
frame          anvnds fr att skapa spelarens animation.
is_moving      anvnds fr att skapa spelarens animation.
kills          representerar antalet fiender som spelaren ddat.

Basklassens metoder:

draw()            ritar ut spelarens animation.
detectBorder()    anvnds fr att se till att spelaren inte kan g utanfr spelomrdet.
shoot()           anvnds fr att avfyra spelarens vapen. Anropar i sin tur antingen gun() eller shotgun() beroende p
                  vilket vapen som spelaren anvnder.
gun()             skapar 1 projektil som representerar ett pistolskott.
shotgun()         skapar 3 projektiler som representerar en hagelskur frn ett hagelgevr.

Subklasserna innehller metoderna keydown() och keyup() som kontrollerar om en tangent tryckts ned som kontrollerar spelarens rrelse.
'''

import pygame, Bullet, Globals
from pygame.locals import *

pygame.mixer.init()

gun_sound = Globals.load_sound('sounds/m1garand.wav')
shotgun_sound = Globals.load_sound('sounds/shotgun.wav')
reload_sound = Globals.load_sound('sounds/reload.wav')

class Player(pygame.sprite.Sprite):
    
    def __init__(self):
        pygame.sprite.Sprite.__init__(self)
        self.Xspeed = 0
        self.Yspeed = 0
        self.weapon = 0
        self.shotgun_found = False
        self.frame = 0
        self.is_moving = False
        self.is_reloading = False
        self.reload_timer = 30
        self.kills = 0
        self.gun_clip = 9
        self.shotgun_clip = 6
        
    def update(self, sprites, screen):
        self.rect = self.rect.move(self.Xspeed, self.Yspeed)
        self.detectBorder(screen)
        if self.kills == 25:
            self.shotgun_found = True
    
    def draw(self, screen):
        top = 0
        font = pygame.font.Font(None, 20)
        if self.weapon == 0:
            top = 1
            text = font.render(str(self.gun_clip), 2, (0,0,0))
            screen.blit(text, (self.rect.x+50, self.rect.y+35))
        elif self.weapon == 1:
            top = 66
            text = font.render(str(self.shotgun_clip), 2, (0,0,0))
            screen.blit(text, (self.rect.x+50, self.rect.y+35))
        
        if self.is_moving == False:
            screen.blit(self.image, self.rect.topleft, (63, top, 61, 64))
            self.frame = 0
        else:
            if self.frame == 60:
                self.frame = 0
            else:
                self.frame += 1
        
            if self.frame <= 15:
                screen.blit(self.image, self.rect.topleft, (1, top, 61, 64))
            elif self.frame > 15 and self.frame <= 30:
                screen.blit(self.image, self.rect.topleft, (63, top, 61, 64))
            elif self.frame > 30 and self.frame <= 45:
                screen.blit(self.image, self.rect.topleft, (125, top, 61, 64))
            elif self.frame > 45 and self.frame <= 60:
                screen.blit(self.image, self.rect.topleft, (63, top, 61, 64))

        if self.is_reloading == True:
            if self.reload_timer > 0:
                self.reload_timer -= 1
            else:
                self.is_reloading = False
                self.reload_timer = 30
                if self.weapon == 0:
                    self.gun_clip = 9
                else:
                    self.shotgun_clip = 6

        
    
    def detectBorder(self, screen):
        if self.rect.right > screen.get_width() or self.rect.left < 0:
            self.rect = self.rect.move(-self.Xspeed, 0)
        if self.rect.bottom > screen.get_height()-45 or self.rect.top < 100:
            self.rect =self.rect.move(0, -self.Yspeed)
            
    def shoot(self, sprites):
        if self.is_reloading == False:
            if self.weapon == 0:
                self.gun(sprites)
            elif self.weapon == 1:
                self.shotgun(sprites)
        else:
            pass
            
    def gun(self, sprites):
        if self.gun_clip > 0:
            self.gun_clip -= 1
            gun_sound.play()
            bullet = Bullet.Bullet(self.rect.midright, 0, self)
            sprites.add(bullet)
        else:
            reload_sound.play()
            self.is_reloading = True
    
    def shotgun(self, sprites):
        if self.shotgun_clip > 0:
            self.shotgun_clip -= 1
            shotgun_sound.play()
            b1 = Bullet.Bullet(self.rect.midright, -1, self)
            b2 = Bullet.Bullet(self.rect.midright, 0, self)
            b3 = Bullet.Bullet(self.rect.midright, 1, self)
            sprites.add(b1)
            sprites.add(b2)
            sprites.add(b3)
        else:
            reload_sound.play()
            self.is_reloading = True
            
class Player1(Player):
   
    def __init__(self):
        super(Player1, self).__init__()
        self.image = Globals.load_image('images/p1.png', -1)
        self.rect = pygame.Rect((10, 200), (37, 63))

    def keydown(self, key):
        
        if key == K_w:
            self.is_moving = True
            self.Yspeed = -5
        elif key == K_s:
            self.is_moving = True
            self.Yspeed = 5
        elif key == K_a:
            self.is_moving = True
            self.Xspeed = -5
        elif key == K_d:
            self.is_moving = True
            self.Xspeed = 5
        elif key == K_1:
            if not self.is_reloading:
                self.weapon = 0
        elif key == K_2:
            if not self.is_reloading:
                if self.shotgun_found == True:
                    self.weapon = 1
                else:
                    pass
    
    def keyup(self, key):
        
        if key == K_w:
            self.is_moving = False
            self.Yspeed = 0
        elif key == K_s:
            self.is_moving = False
            self.Yspeed = 0
        elif key == K_a:
            self.is_moving = False
            self.Xspeed = 0
        elif key == K_d:
            self.is_moving = False
            self.Xspeed = 0
        
class Player2(Player):
   
    def __init__(self):
        super(Player2, self).__init__()
        self.image = Globals.load_image('images/p2.png', -1)
        self.rect = pygame.Rect((10, 400), (37, 63))

    def keydown(self, key):
        
        if key == K_UP:
            self.is_moving = True
            self.Yspeed = -5
        elif key == K_DOWN:
            self.is_moving = True
            self.Yspeed = 5
        elif key == K_LEFT:
            self.is_moving = True
            self.Xspeed = -5
        elif key == K_RIGHT:
            self.is_moving = True
            self.Xspeed = 5
        elif key == K_9:
            self.weapon = 0
        elif key == K_0:
            if self.shotgun_found == True:
                self.weapon = 1
            else:
                pass
    
    def keyup(self, key):
        
        if key == K_UP:
            self.is_moving = False
            self.Yspeed = 0
        elif key == K_DOWN:
            self.is_moving = False
            self.Yspeed = 0
        elif key == K_LEFT:
            self.is_moving = False
            self.Xspeed = 0
        elif key == K_RIGHT:
            self.is_moving = False
            self.Xspeed = 0
        
