/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.awt;

import com.jogamp.nativewindow.awt.AWTGraphicsConfiguration;
import com.jogamp.nativewindow.awt.AWTGraphicsDevice;
import com.jogamp.nativewindow.awt.AWTGraphicsScreen;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.WindowUpdateEvent;
import com.jogamp.newt.event.awt.AWTKeyAdapter;
import com.jogamp.newt.event.awt.AWTMouseAdapter;
import com.jogamp.newt.event.awt.AWTWindowAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.util.Point;
import jogamp.newt.WindowImpl;
import jogamp.newt.driver.awt.AWTCanvas;
import jogamp.newt.driver.awt.DisplayDriver;
import jogamp.newt.driver.awt.ScreenDriver;

public class WindowDriver
extends WindowImpl {
    private boolean owningFrame;
    private Container container = null;
    private Frame frame = null;
    private AWTCanvas canvas;

    public WindowDriver() {
        this(null);
    }

    public static Class<?>[] getCustomConstructorArgumentTypes() {
        return new Class[]{Container.class};
    }

    public WindowDriver(Container container) {
        this.container = container;
        if (container instanceof Frame) {
            this.frame = (Frame)container;
        }
    }

    @Override
    protected void requestFocusImpl(boolean bl) {
        this.container.requestFocus();
    }

    @Override
    protected void setTitleImpl(String string) {
        if (this.frame != null) {
            this.frame.setTitle(string);
        }
    }

    @Override
    protected void createNativeImpl() {
        if (0L != this.getParentWindowHandle()) {
            throw new RuntimeException("Window parenting not supported in AWT, use AWTWindow(Frame) cstr for wrapping instead");
        }
        if (null == this.container) {
            this.frame = new Frame();
            this.container = this.frame;
            this.owningFrame = true;
        } else {
            this.owningFrame = false;
            this.defineSize(this.container.getWidth(), this.container.getHeight());
            this.definePosition(this.container.getX(), this.container.getY());
        }
        if (null != this.frame) {
            this.frame.setTitle(this.getTitle());
        }
        this.container.setLayout(new BorderLayout());
        this.canvas = new AWTCanvas(this, this.capsRequested, this.capabilitiesChooser);
        this.container.add((Component)this.canvas, "Center");
        new AWTMouseAdapter(this).addTo(this.canvas);
        new AWTKeyAdapter(this).addTo(this.canvas);
        new AWTWindowAdapter(new LocalWindowListener(), (Window)this).addTo(this.canvas);
        this.reconfigureWindowImpl(this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.getReconfigureFlags(18, true));
        this.setWindowHandle(1L);
    }

    @Override
    protected void closeNativeImpl() {
        this.setWindowHandle(0L);
        if (null != this.container) {
            this.container.setVisible(false);
            this.container.remove(this.canvas);
            this.container.setEnabled(false);
            this.canvas.setEnabled(false);
        }
        if (this.owningFrame && null != this.frame) {
            this.frame.dispose();
            this.owningFrame = false;
            this.frame = null;
        }
    }

    @Override
    public boolean hasDeviceChanged() {
        boolean bl = this.canvas.hasDeviceChanged();
        if (bl) {
            AWTGraphicsConfiguration aWTGraphicsConfiguration = this.canvas.getAWTGraphicsConfiguration();
            if (null == aWTGraphicsConfiguration) {
                throw new NativeWindowException("Error Device change null GraphicsConfiguration: " + this);
            }
            this.setGraphicsConfiguration(aWTGraphicsConfiguration);
            ((ScreenDriver)this.getScreen()).setAWTGraphicsScreen((AWTGraphicsScreen)aWTGraphicsConfiguration.getScreen());
            ((DisplayDriver)this.getScreen().getDisplay()).setAWTGraphicsDevice((AWTGraphicsDevice)aWTGraphicsConfiguration.getScreen().getDevice());
            ((ScreenDriver)this.getScreen()).updateVirtualScreenOriginAndSize();
        }
        return bl;
    }

    @Override
    protected void updateInsetsImpl(javax.media.nativewindow.util.Insets insets) {
        Insets insets2 = this.container.getInsets();
        insets.setLeftWidth(insets2.left);
        insets.setRightWidth(insets2.right);
        insets.setTopHeight(insets2.top);
        insets.setBottomHeight(insets2.bottom);
    }

    @Override
    protected boolean reconfigureWindowImpl(int n, int n2, int n3, int n4, int n5) {
        Cloneable cloneable;
        if (0 != (2 & n5) && null != this.frame) {
            if (!this.container.isDisplayable()) {
                this.frame.setUndecorated(this.isUndecorated());
            } else if (DEBUG_IMPLEMENTATION) {
                System.err.println(WindowDriver.getThreadName() + ": AWTWindow can't undecorate already created frame");
            }
        }
        Dimension dimension = new Dimension(n3, n4);
        this.canvas.setMinimumSize(dimension);
        this.canvas.setPreferredSize(dimension);
        this.canvas.setSize(dimension);
        if (DEBUG_IMPLEMENTATION) {
            cloneable = this.container.getInsets();
            Dimension dimension2 = new Dimension(n3 + cloneable.left + cloneable.right, n4 + cloneable.top + cloneable.bottom);
            System.err.println(WindowDriver.getThreadName() + ": AWTWindow new size: szClient " + dimension + ", szCont " + dimension2 + ", insets " + cloneable);
        }
        if (0 != (0x10 & n5)) {
            if (null != this.frame) {
                this.frame.pack();
            }
            this.container.validate();
            this.container.setVisible(0 != (0x1000 & n5));
        }
        this.container.setLocation(n, n2);
        if (0 != (0x10 & n5)) {
            if (0 != (0x1000 & n5) && !this.hasDeviceChanged()) {
                cloneable = this.canvas.getAWTGraphicsConfiguration();
                if (null == cloneable) {
                    throw new NativeWindowException("Error: !hasDeviceChanged && null == GraphicsConfiguration: " + this);
                }
                this.setGraphicsConfiguration((AbstractGraphicsConfiguration)cloneable);
            }
            this.visibleChanged(false, 0 != (0x1000 & n5));
        } else {
            this.container.invalidate();
            if (null != this.frame) {
                this.frame.pack();
            }
            this.container.validate();
        }
        return true;
    }

    @Override
    protected Point getLocationOnScreenImpl(int n, int n2) {
        java.awt.Point point = this.canvas.getLocationOnScreen();
        point.translate(n, n2);
        return new Point((int)(point.getX() + 0.5), (int)(point.getY() + 0.5));
    }

    @Override
    public Object getWrappedWindow() {
        return this.canvas;
    }

    class LocalWindowListener
    implements WindowListener {
        LocalWindowListener() {
        }

        @Override
        public void windowMoved(WindowEvent windowEvent) {
            if (null != WindowDriver.this.container) {
                WindowDriver.this.positionChanged(false, WindowDriver.this.container.getX(), WindowDriver.this.container.getY());
            }
        }

        @Override
        public void windowResized(WindowEvent windowEvent) {
            if (null != WindowDriver.this.canvas) {
                WindowDriver.this.sizeChanged(false, WindowDriver.this.canvas.getWidth(), WindowDriver.this.canvas.getHeight(), false);
            }
        }

        @Override
        public void windowDestroyNotify(WindowEvent windowEvent) {
            WindowDriver.this.windowDestroyNotify(false);
        }

        @Override
        public void windowDestroyed(WindowEvent windowEvent) {
            if (WindowDriver.this.isNativeValid()) {
                WindowDriver.this.windowDestroyNotify(true);
            }
        }

        @Override
        public void windowGainedFocus(WindowEvent windowEvent) {
            WindowDriver.this.focusChanged(false, true);
        }

        @Override
        public void windowLostFocus(WindowEvent windowEvent) {
            WindowDriver.this.focusChanged(false, false);
        }

        @Override
        public void windowRepaint(WindowUpdateEvent windowUpdateEvent) {
            WindowDriver.this.windowRepaint(false, 0, 0, WindowDriver.this.getWidth(), WindowDriver.this.getHeight());
        }
    }
}

