#!/usr/bin/python

from socket import socket,AF_INET,SOCK_DGRAM,SO_REUSEADDR,SOL_SOCKET,SO_BROADCAST,timeout as SocketTimeout,error as SocketError
import sys
import random
import json
from time import time
from traceback import print_exc
import pygame
#from pygame.locals import *

pygame.init()
pygame.font.init()

def updateRemote(info):
    if "remote" in boards:
        boards["remote"].load(info)
    else:
        rb = Board(info)
        rb.x = 582
        rb.y = 158
        rb.setScale(400,400)
        boards["remote"] = rb
        items.append(rb)
class NetProto:
    def parseCMD(self, cmd, info):
        if cmd == "update":
            if "remote" in boards:
                boards["remote"].load(info)
            else:
                updateRemote(info)


class NetServer(NetProto):
    def __init__(self):
        self.port = 1829
        self.sock = socket(AF_INET,SOCK_DGRAM)
        self.sock.setsockopt(SOL_SOCKET,SO_REUSEADDR,1)
        self.sock.setblocking(False)
        self.sock.bind(("",self.port))
        self.remote = None
        
    def poll(self):
        global boards
        try:
            data,src = self.sock.recvfrom(65535)
            cmd, info = data.split(None,1)
            print repr(cmd)
            if self.remote == None:
                if cmd == "mmmsearch":
                    print "Sending response"
                    self.sock.sendto("mmmserver v1.0",src)
                    self.remote = src
                    self.sendUpdate()
            else:
                if cmd == "update":
                    if "remote" in boards:
                        boards["remote"].load(info)
                    else:
                        updateRemote(info)
                
        except SocketError:
            return
        except SocketTimeout:
            return
        #print data
    def sendUpdate(self):
        if self.remote:
            self.sock.sendto("update "+board.dump()+"\n",self.remote)

class NoServer(Exception): pass

class NetClient(NetProto):
    def __init__(self):
        self.sock = socket(AF_INET,SOCK_DGRAM)
        self.sock.bind(('',1830))
        self.sock.setsockopt(SOL_SOCKET, SO_BROADCAST, 1)
        self.sock.settimeout(0.1)
        for tries in range(5):
            self.sock.sendto("mmmsearch v1.0",("<broadcast>",1829))
            try:
                data, src = self.sock.recvfrom(65535)
                self.remote = src
                #self.sock.settimeout(0.5)
                self.sock.setblocking(False)
                self.sendUpdate()
                return
            except SocketTimeout:
                print_exc()
        self.sock.close()
        raise NoServer("No server found")
    def sendUpdate(self):
        self.sock.sendto("update "+board.dump()+"\n",self.remote)
    def poll(self):
        try:
            data, src = self.sock.recvfrom(65535)
            cmd, info = data.split(None,1)
            self.parseCMD(cmd,info)
        except SocketTimeout:
            pass
        except SocketError:
            pass
            


size = width, height = 1024, 600
black = 0, 0, 0

cardsize = cardwidth, cardheight = 80, 80

font = pygame.font.Font(None, 36)

cardback = pygame.Surface( cardsize )
cardback.fill(black)
backtext = font.render("B", 1, (100, 100, 100))
backtextpos = backtext.get_rect()
backtextpos.centerx = cardback.get_rect().centerx
backtextpos.centery = cardback.get_rect().centery
cardback.blit(backtext, backtextpos)
cardback = pygame.image.load("img/ned/cb.png")

def getFront(num):
    cardfront = pygame.Surface( cardsize )
    cardfront.fill(black)
    cardfront.fill(black)
    fronttext = font.render("F%d"%num, 1, (100, 100, 100))
    fronttextpos = fronttext.get_rect()
    fronttextpos.centerx = cardfront.get_rect().centerx
    fronttextpos.centery = cardfront.get_rect().centery
    cardfront.blit(fronttext, fronttextpos)
    try:
        cardfront = pygame.image.load("img/ned/cf%s.png"%num)
    except:
        print "Warning: Could not load card face %r"%num
    return cardfront

class Card(pygame.sprite.Sprite):
    def __init__(self,name=None,front=None,back=None):
        pygame.sprite.Sprite.__init__(self)
        self.name = name
        self.front = front
        self.back = back
        self.width = cardwidth
        self.height = cardheight
        self.flipped = False
        self.show = True
        self.flipSpeed = 10
        self.flipPos = -1.0
    def dump(self):
        out = dict([(k,v) for k,v in self.__dict__.items() if not k.startswith("_") and
                k not in ("front","back","width","height")])
        a = []
        jd = json.dumps(out)
        return jd

    def load(self, jd):
        data = json.loads(jd)
        self.__dict__.update(data)
        self.front = cardmap[self.name][0]
        self.back = cardmap[self.name][1]
        return self
        
    def flip(self):
        self.flipPos = 1.0
        self.lastUpdate = time()
    def animate(self):
        if self.flipPos > -1.0:
            self.flipPos -= self.flipSpeed
            return True
        return False
    def draw(self,y,x,surface):
        if not self.show and self.flipPos < 0.0: return False
        if self.flipPos > -1.0:
            if self.flipPos >= 0.0 and not self.flipped:
                width = int(self.width*self.flipPos)
                img = pygame.transform.smoothscale(self.front,(width,self.height))
            elif self.flipPos < 0.0 and not self.flipped:
                width = int(self.width*abs(self.flipPos))
                img = pygame.transform.smoothscale(self.back,(width,self.height))
            elif self.flipPos >= 0.0 and self.flipped:
                width = int(self.width*self.flipPos)
                img = pygame.transform.smoothscale(self.back,(width,self.height))
            elif self.flipPos < 0.0 and self.flipped:
                width = int(self.width*abs(self.flipPos))
                img = pygame.transform.smoothscale(self.front,(width,self.height))
            surface.blit(img,(x+((self.width/2)-(width/2)),y))
            self.flipPos -= (time()-self.lastUpdate) * self.flipSpeed
            self.lastUpdate = time()
        else:
            if self.flipped:
                surface.blit(self.front,(x,y))
                return False
            else:
                surface.blit(self.back,(x,y))

        return True

cardmap = dict([("cf%d"%card,(getFront(card),cardback)) for card in range(36/2)])
cards = [Card("cf%d"%(card/2),*(cardmap.get("cf%d"%(card/2)))) for card in range(36)]
random.shuffle(cards)

class TextBox:
    def __init__(self, text):
        self.text = font.render(text, 1, (250,250,250))
        self.textpos = self.text.get_rect()

    def draw(self, surface):
        self.textpos.centerx = surface.get_rect().centerx
        self.textpos.centery = surface.get_rect().centery
        surface.blit(self.text, self.textpos)
    def press(self,x,y):
        pass


class Board(pygame.sprite.Sprite):
    def __init__(self,data=None):
        pygame.sprite.Sprite.__init__(self)
        self.name = None
        self.remote = False
        self.numcards = (6,6)
        self.padding = 5
        self.acceptInput = True
        self.x = 42
        self.y = 43
        self.scaleto = None
        self.combo = 0
        self.cardsLeft = self.numcards[0]*self.numcards[1]
        self.image = pygame.Surface( (
            self.padding+self.numcards[0]*(cardwidth+self.padding),
            self.padding+self.numcards[1]*(cardheight+self.padding),
            ))
        self.rect = pygame.Rect((self.x, self.y),self.image.get_size())
        self.array = []
        self.animate = []
        if not data:
            self.create()
        if data:
            self.load(data)
    def setScale(self,w,h):
        self.scaleto = (w,h)
        self.scaleSurface = pygame.Surface(self.scaleto)
    def dump(self):
        out = dict([(k,v) for k,v in self.__dict__.items() if not k.startswith("_") and
                k not in ("image","rect","array","x","y","scaleto","scaleSurface","acceptInput")])
        out["array"] = [[card.dump() for card in row] for row in self.array]
        out["animate"] = [card.dump() for card in self.animate]
        out["flipped"] = [card.dump() for card in self.flipped]
        jd = json.dumps(out)
        return jd

    def load(self,jd):
        data = json.loads(jd)
        data["array"] = [[Card().load(card) for card in row] for row in data["array"]]
        data["animate"] = [Card().load(card) for card in data["animate"]]
        data["flipped"] = [Card().load(card) for card in data["flipped"]]
        self.__dict__.update(data)
        self.remote = True
        self.acceptInput = False
        
    def create(self):
        w,h = self.numcards
        ca = cards+[]
        self.array = []
        self.flipped = []
        for y in range(h):
            row = []
            for x in range(w):
                row.append(ca.pop())
            self.array.append(row)

    def draw(self, surface):
        padding = self.padding
        x = self.x
        y = self.y
        #self.image.fill((10,50,10))
        self.image.fill((0x6f,0x03,0x57))
        anim = self.animate+[]
        cardsLeft = 0
        for a in anim:
            if a.animate() == False:
                self.animate.remove(a)
        for cy,ya in enumerate(self.array):
            for cx,card in enumerate(ya):
                cardsLeft += self.array[cx][cy].draw(padding+cy*(cardheight+padding),(padding+cx*(cardwidth+padding)),self.image)
                #surface.blit(cardback,(x+cx*(cardheight+padding),y+cy*(cardwidth+padding)))
        self.cardsLeft = cardsLeft
        if cardsLeft == 0:
            if self.remote:
                board.acceptInput = False
                items.append(TextBox("You Lose!"))
            else:
                self.acceptInput = False
                items.append(TextBox("You Win!"))
                if (int(time()*1000)%200) == 0:
                    net.sendUpdate()
        if self.scaleto:
            pygame.transform.smoothscale(self.image,self.scaleto,self.scaleSurface)
            surface.blit(self.scaleSurface,(x,y))
        else:
            surface.blit(self.image,(x,y))
   
    def press(self,x,y):
        if len(self.animate): return
        if not self.acceptInput: return
        if (    x > self.rect.left+self.padding and 
                x < self.rect.left+self.rect.width and
                y > self.rect.top+self.padding and 
                y < self.rect.top+self.rect.height-self.padding):
            cx = (x-self.x-self.padding)/(cardwidth+self.padding)
            cy = (y-self.y-self.padding)/(cardheight+self.padding)
            card = self.array[cx][cy]
            if len(self.flipped) < 2:
                if not card.show: return
                if card in self.flipped: return
                print "Flipped "+card.name
                card.flip()
                card.flipped = True
                self.flipped.append(card)
                if len(self.flipped) >= 2 and self.flipped[0].name == self.flipped[1].name:
                    self.combo += 1
                else:
                    self.combo = 0
            else:
                if self.flipped[0].name == self.flipped[1].name:
                    for f in self.flipped:
                        f.show = False
                        f.flipped = False
                        f.flip()
                else:
                    for f in self.flipped:
                        f.flip()
                        f.flipped = False
                self.flipped = []
            net.sendUpdate()
        print event.pos


screen = pygame.display.set_mode(size)
pygame.display.set_caption('Multiplayer Mayhem')

background = pygame.Surface(screen.get_size())
background = background.convert()
#background.fill((250, 250, 250))
background.fill((230,10,10))
background = pygame.transform.smoothscale(pygame.image.load("img/bg.png"),size)
plate = pygame.Surface((1024-60,600-60)).convert_alpha()
plate.fill((50,0,40,190))
background.blit(plate,(30,30))


font = pygame.font.Font(None, 42)
text = font.render("Multiplayer Mayhem", 1, (253,184,88))
textpos = text.get_rect()
#textpos.centerx = background.get_rect().centerx
textpos.x = 640
textpos.y = 80
background.blit(text, textpos)

board = Board()

items = [board]
boards = dict(
    local=board,
)

try:
    net = NetClient()
except NoServer:
    print_exc()
    print "No server found"
    net = NetServer()

while 1:
    for event in pygame.event.get():
        if event.type == pygame.QUIT: sys.exit()
        elif event.type == pygame.MOUSEBUTTONDOWN:
            for item in items:
                item.press(*event.pos)
        elif event.type == pygame.KEYDOWN:
            if event.unicode == "q" or event.key == pygame.K_ESCAPE:
                screen.fill(black)
                pygame.display.flip()
                sys.exit()
            elif event.unicode == "w":
                cards = sum(board.array,[])
                leave = cards[0].name
                for card in cards:
                    if card.name != leave:
                        card.show = False
    net.poll()
    screen.fill(black)
    screen.blit(background, (0,0))
    for item in items:
        item.draw(screen)
    pygame.display.flip()

