import pygame, Utils
from pygame.locals import *

class Star(pygame.sprite.Sprite):

    def __init__(self, place, size, speed):
        pygame.sprite.Sprite.__init__(self)
        self._layer = -2
        self.speed = speed
        if size == 0:
            self.image = Utils.load_image('images/star_small.png', -1)
        else:
            self.image = Utils.load_image('images/star_large.png', -1)
        self.rect = pygame.Rect(place, (8, 8))

    def draw(self, screen):
        screen.blit(self.image, self.rect.topleft)

    def detectBorder(self, sprites, screen):
        if self.rect.left < 0:
            sprites.remove(self)
        if self.rect.top < 0:
            sprites.remove(self)
            
    def update(self, sprites, screen):
        self.rect = self.rect.move(self.speed, 0)
        self.detectBorder(sprites, screen)
    
