import pygame, Utils, math
from pygame.locals import *

class Unicorn(pygame.sprite.Sprite):

    def __init__(self, place):
        pygame.sprite.Sprite.__init__(self)
        self.image = Utils.load_image('images/space_unicorn.png', -1)
        self.rect = pygame.Rect(place, (385, 608))
        self.frame = 0
        self.inc = True
        self.xSpeed = -2

    def draw(self, screen):
        if self.inc:
            screen.blit(self.image, self.rect.topleft, (1, 1, 385, 608))
        elif not self.inc:
            screen.blit(self.image, self.rect.topleft, (385, 1, 385, 608))

    def toggle(self):
        if self.inc == True:
            self.inc = False
        else:
            self.inc = True
    
    def update(self, sprites, screen):
        self.frame += 1
        
        if self.frame % (5*60) == 0 or self.frame % (12*60) == 0:
            self.xSpeed = 0
        if self.frame % (7*60) == 0:
            self.xSpeed = -1
        if self.frame % (9*60) == 0:
            self.xSpeed = 2
        if self.frame % (10*60) == 0:
            self.xSpeed = -1
        if self.frame % (56*60) == 0:
            self.xSpeed = -5
            
        t = pygame.time.get_ticks() / 2  % 400
        x = t
        y = math.sin(t/50.0) * 20 + 50
        y = int(y)
        self.rect = self.rect.move(self.xSpeed, y - self.rect.y)
        
        if self.frame % 10 == 0:
            self.toggle()

        if self.frame == (60*60):
            sprites.remove(self)
        
