/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class Input
implements KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    public final int left = 37;
    public final int right = 39;
    public final int up = 38;
    public final int down = 40;
    public final int space = 32;
    public final int escape = 27;
    public final int LEFT = 37;
    public final int RIGHT = 39;
    public final int UP = 38;
    public final int DOWN = 40;
    public final int SPACE = 32;
    public final int ENTER = 10;
    public final int BACKSPACE = 8;
    public final int ESCAPE = 27;
    public final int SHIFT = 16;
    public final int CTRL = 17;
    public final int W = 87;
    public final int A = 65;
    public final int S = 83;
    public final int D = 68;
    public final int I = 73;
    public final int Q = 81;
    public final int M = 77;
    public final int C = 67;
    public final int R = 82;
    public final int T = 84;
    public final int N = 78;
    public final int J = 74;
    public final int H = 72;
    public final int E = 69;
    private boolean[] keys = new boolean[1000];
    private boolean[] previousKeys = new boolean[1000];
    private int keysDown = 0;
    private int mx;
    private int my;
    private boolean mouseLeftDown;
    private boolean mouseRightDown;
    private boolean mouseCenterDown;
    private boolean previousMouseLeftDown;
    private boolean previousMouseRightDown;
    private boolean previousMouseCenterDown;
    private boolean collectMouseLeftDown;
    private boolean collectMouseRightDown;
    private boolean collectMouseCenterDown;
    private boolean mouseWheelMoved;
    private int mouseWheelNotches;
    private boolean decorated;
    private int topDecorationSize = 29;
    private int sideAndBotDecorationSize = 7;
    private char latestTyped;
    boolean[] collectKeys = new boolean[1000];

    public Input(Component c, boolean decorated) {
        c.addMouseListener(this);
        c.addMouseMotionListener(this);
        c.addKeyListener(this);
        c.addMouseWheelListener(this);
        c.setFocusable(true);
        this.decorated = decorated;
    }

    public void changeFocus(Component c) {
        c.requestFocus();
    }

    public synchronized void update() {
        this.previousKeys = (boolean[])this.keys.clone();
        this.keys = (boolean[])this.collectKeys.clone();
        this.previousMouseLeftDown = this.mouseLeftDown;
        this.previousMouseRightDown = this.mouseRightDown;
        this.previousMouseCenterDown = this.mouseCenterDown;
        this.mouseLeftDown = this.collectMouseLeftDown;
        this.mouseRightDown = this.collectMouseRightDown;
        this.mouseCenterDown = this.collectMouseCenterDown;
    }

    @Override
    public synchronized void keyPressed(KeyEvent e) {
        this.collectKeys[e.getKeyCode()] = true;
        ++this.keysDown;
    }

    @Override
    public synchronized void keyReleased(KeyEvent e) {
        this.collectKeys[e.getKeyCode()] = false;
        --this.keysDown;
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.latestTyped = e.getKeyChar();
    }

    public boolean hasLatestTyped() {
        return this.latestTyped != '\u0000' && this.latestTyped >= ' ' && this.latestTyped <= '\u00ff';
    }

    public char getLatestTyped() {
        char c = this.latestTyped;
        this.latestTyped = '\u0000';
        return c;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public synchronized void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.collectMouseLeftDown = true;
        } else if (e.getButton() == 2) {
            this.collectMouseCenterDown = true;
        } else if (e.getButton() == 3) {
            this.collectMouseRightDown = true;
        }
    }

    @Override
    public synchronized void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1) {
            this.collectMouseLeftDown = false;
        } else if (e.getButton() == 2) {
            this.collectMouseCenterDown = false;
        } else if (e.getButton() == 3) {
            this.collectMouseRightDown = false;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mx = e.getX();
        this.my = e.getY();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mx = e.getX();
        this.my = e.getY();
    }

    public boolean isKeyDown(int k) {
        return this.keys[k] || this.previousKeys[k];
    }

    public boolean isKeyPressed(int k) {
        return this.keys[k] && !this.previousKeys[k];
    }

    public boolean isKeyReleased(int k) {
        return !this.keys[k] && this.previousKeys[k];
    }

    public int getMouseX() {
        return this.mx - (this.decorated ? this.sideAndBotDecorationSize : 0);
    }

    public int getMouseY() {
        return this.my - (this.decorated ? this.topDecorationSize : 0);
    }

    public Point getMousePoint() {
        return new Point(this.getMouseX(), this.getMouseY());
    }

    public boolean isMouseDown() {
        return this.mouseLeftDown || this.mouseRightDown || this.mouseCenterDown;
    }

    public boolean isMouseLeftDown() {
        return this.mouseLeftDown;
    }

    public boolean isMouseRightDown() {
        return this.mouseRightDown;
    }

    public boolean isMouseCenterDown() {
        return this.mouseCenterDown;
    }

    public boolean isMouseLeftPressed() {
        return this.mouseLeftDown && !this.previousMouseLeftDown;
    }

    public boolean isMouseRightPressed() {
        return this.mouseRightDown && !this.previousMouseRightDown;
    }

    public boolean isMouseCenterPressed() {
        return this.mouseCenterDown && !this.previousMouseCenterDown;
    }

    public boolean isMouseLeftReleased() {
        return !this.mouseLeftDown && this.previousMouseLeftDown;
    }

    public boolean isMouseRightReleased() {
        return !this.mouseRightDown && this.previousMouseRightDown;
    }

    public boolean isMouseCenterReleased() {
        return !this.mouseCenterDown && this.mouseCenterDown;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.mouseWheelMoved = true;
        this.mouseWheelNotches = e.getWheelRotation();
    }

    public boolean isMouseWheelMoved() {
        if (this.mouseWheelMoved) {
            this.mouseWheelMoved = false;
            this.mouseWheelNotches = 0;
            return true;
        }
        return false;
    }

    public int getMouseWheelNotches() {
        this.mouseWheelMoved = false;
        int temp = this.mouseWheelNotches;
        this.mouseWheelNotches = 0;
        return temp;
    }

    public boolean isAnyKeyDown() {
        return this.keysDown > 0;
    }
}

