/*
 * Decompiled with CFR 0.152.
 */
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.swing.JOptionPane;

public class Sound {
    public static final SoundFile GAME_MUSIC = new SoundFile("return to the cave.wav");
    public static final SoundFile LUGN = new SoundFile("lugn.wav");
    private SoundFile currentMusic;
    private double soundVolume;
    private double musicVolume;
    private Clip musicClip;

    public Sound(double soundVolume, double musicVolume) {
        this.soundVolume = soundVolume;
        this.musicVolume = musicVolume;
    }

    public void playSound(SoundFile sound) {
        try {
            Clip clip = (Clip)AudioSystem.getLine(sound.info);
            clip.open(sound.af, sound.audio, 0, sound.size);
            FloatControl volume = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
            volume.setValue((float)(20.0 * Math.log10(this.soundVolume)));
            clip.start();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "play sound " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void setMusic(SoundFile music) {
        if (this.currentMusic == music) {
            return;
        }
        if (this.musicClip != null) {
            this.musicClip.stop();
        }
        this.currentMusic = music;
        try {
            this.musicClip = (Clip)AudioSystem.getLine(music.info);
            this.musicClip.open(music.af, music.audio, 0, music.size);
            this.musicClip.loop(-1);
            FloatControl volume = (FloatControl)this.musicClip.getControl(FloatControl.Type.MASTER_GAIN);
            volume.setValue((float)(20.0 * Math.log10(this.musicVolume)));
            this.musicClip.start();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "set music " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void stopMusic() {
        this.currentMusic = null;
        this.musicClip.stop();
    }
}

