package com.geekparty.shooter {
	import com.geekparty.shooter.core.managers.*;
	import com.geekparty.shooter.view.*;
	import flash.display.*;
	import flash.events.*;
	import flash.media.Sound;
	import flash.media.SoundChannel;
	import flash.media.SoundTransform;
	/**
	 * ...
	 * @author Frost
	 */
	[Frame(factoryClass = "Preloader")]
	
	
	
	public class Main extends Sprite {	
		
		private static var _inst:Main;
		public var mouseDown:Boolean;
		
		public var observer:EventDispatcher;
		
		public var left:Boolean;
		public var right:Boolean;
		
		public var up:Boolean;
		
		public static function get instance():Main {
			if (_inst == null) {
				_inst = new Main();
			}
			return _inst;
		}
		
		public var layers:Layers;
		
		public function Main():void {
			if (stage) {
				init();
			} else {
				addEventListener(Event.ADDED_TO_STAGE, init);
			}
			observer = new EventDispatcher();
		}
		
		private function init(e:Event = null):void {
			removeEventListener(Event.ADDED_TO_STAGE, init);
			layers = new Layers(this);
			var music:Sound = new Assets.music() as Sound;
			var str:SoundTransform = new SoundTransform(0.3);
			var ch:SoundChannel = music.play(0, 5000);
			ch.soundTransform = str;
			
			//(.play(0, 5000);
			
			ScreenManager.instance.changeScreen(Screen.TYPE_SPLASH);
			
			addEventListener(Event.ENTER_FRAME, onFrame);
			
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
			stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
		}
		
		private function onMouseDown(e:MouseEvent):void {
			mouseDown = true;
		}
		
		private function onMouseUp(e:MouseEvent):void {
			mouseDown = false;
		}
		
		private function onKeyDown(e:KeyboardEvent):void {
			switch (e.keyCode) {
				case 65: 
				case 37: 
					left = true;
					break;
				case 68: 
				case 39: 
					right = true;
					break;
				case 87: 
				case 32: 
					up = true;
					break;
			}
		}
		
		private function onKeyUp(e:KeyboardEvent):void {
			switch (e.keyCode) {
				case 65: 
				case 37: 
					left = false;
					break;
				case 68: 
				case 39: 
					right = false;
					break;
				case 87: 
				case 32: 
					up = false;
					break;
			}
		}
		
		private function onFrame(e:Event):void {
			observer.dispatchEvent(e);
		}
	}
}