package com.geekparty.shooter.view.game {
	import com.geekparty.shooter.view.game.enemies.UnderwaterMine;
	import flash.display.InteractiveObject;
	import flash.display.Sprite;
	
	/**
	 * ...
	 * @author Frost
	 */
	public class EnemyGenerator {
		
		private static var TYPE_UNDERWATER_MINE:int = 0;
		
		public var enemies:Vector.<Enemy>;
		private var container:Sprite;
		private var randomTime:Number;
		private var enemyTick:int;
		
		private var enemy_id:int;
		private var generateTime:Number;
		private var difficult:int;
		private var difficultTicks:int;
		
		private function get enemyID():int {
			enemy_id++;
			return enemy_id;
		}
		
		public function EnemyGenerator() {
			enemies = new Vector.<Enemy>();
			enemyTick = 0;
			generateTime = 200;
			setRandom();
			enemy_id = -1;
		}
		
		private function setRandom():void {
			randomTime = Math.random() * 100;
		}
		
		public function init(container:Sprite):void {
			this.container = container;
			difficultTicks = 150;
			gameTick = 0;
		
		}
		
		private var gameTick:int;
		
		public function tick():void {
			enemyTick++;
			gameTick++;
			if (gameTick > difficultTicks) {
				gameTick = 0;
				generateTime -= 5;
				generateTime = Math.max(30, generateTime);
			}
			
			if (enemyTick >= (generateTime + randomTime)) {
				generateNewOne();
				enemyTick = 0;
				setRandom();
			}
			var i:int;
			for (i = 0; i < enemies.length; i++) {
				enemies[i].move();
			}
		}
		
		public function stop():void {
			var i:int;
			for (i = 0; i < enemies.length; i++) {
				enemies[i].stop();
			}
		}
		
		private function generateNewOne():void {
			var randomNumber:int = Math.floor(Math.random() * 1);
			switch (randomNumber) {
				case TYPE_UNDERWATER_MINE: 
					var mine_1:UnderwaterMine = new UnderwaterMine();
					mine_1.init(removeCallBack);
					mine_1.enemyID = enemyID;
					enemies.push(mine_1);
					container.addChild(mine_1);
					break;
			
			}
			enemies[enemies.length - 1].y = enemies[enemies.length - 1].addingHeight;
			enemies[enemies.length - 1].x = 1300;
		}
		
		private function removeCallBack(e:Enemy):void {
			var i:int;
			for (i = 0; i < enemies.length; i++) {
				if (enemies[i].enemyID == e.enemyID) {
					enemies.splice(i, 1);
					break;
				}
			}
		}
	}
}