package com.geekparty.shooter.view.game {
	import com.geekparty.shooter.view.game.enemies.Plane_1;
	import com.geekparty.shooter.view.screens.Game;
	import flash.display.Sprite;
	
	/**
	 * ...
	 * @author Frost
	 */
	public class FlyEnemyGenerator {
		
		private static var TYPE_PLAIN_1:int = 0;
		
		public var enemies:Vector.<Enemy>;
		private var container:Sprite;
		private var enemyTick:int;
		private var randomTime:Number;
		
		private var generateTime:int;
		
		private var enemy_id:int;
		private var bulletGenerator:BulletGenerator;
		
		
		private var difficult:int;
		private var difficultTicks:int;
		
		private function get enemyID():int {
			enemy_id++;
			return enemy_id;
		}
		
		public function FlyEnemyGenerator() {
			enemies = new Vector.<Enemy>();
			enemyTick = 0;
			generateTime = 90;
			setRandom();
			enemy_id = -1;
		}
		
		public function init(container:Sprite, bulletGenerator:BulletGenerator, bonusGenerator:BonusGenerator):void {
			this.bonusGenerator = bonusGenerator;
			this.bulletGenerator = bulletGenerator;
			this.container = container;
			difficultTicks = 150;
			bombThowingTime = 40;
		}
		
		private function setRandom():void {
			randomTime = Math.random() * 100;
			gameTick = 0;
		}
		
		private var gameTick:int;
		
		public function tick():void {
			enemyTick++;
			gameTick++;
			
			if (gameTick > difficultTicks)
			{
				bombThowingTime -= 5;
				trace('HARDER');
				if (bombThowingTime < -30) {
					bombThowingTime = -30;
				}
				gameTick = 0;
				generateTime -= 5;
				generateTime = Math.max(30, generateTime ); 
			}
			
			if (enemyTick >= (generateTime + randomTime)) {
				generateNewOne();
				enemyTick = 0;
				setRandom();
			}
			var i:int;
			for ( i = 0; i < enemies.length; i++) {
				enemies[i].move();
			}
		}
		
		private var bonusGenerator:BonusGenerator;
		private var bombThowingTime:int;
		
		private function generateNewOne():void {
			var randomNumber:int = Math.floor(Math.random() * 1);
			switch (randomNumber) {
				case TYPE_PLAIN_1:
					var plane_1:Plane_1 = new Plane_1();
					plane_1.init(bombThowingTime, removeCallBack, bulletGenerator, bonusGenerator);
					plane_1.enemyID = enemyID;
					enemies.push(plane_1);
					container.addChild(plane_1);
					break;
			}
			enemies[enemies.length - 1].y = enemies[enemies.length - 1].addingHeight;
			enemies[enemies.length - 1].x = 1600;
		}
		
		private function removeCallBack(e:Enemy):void {
			var i:int;
			for (i = 0; i < enemies.length; i++) {
				if (enemies[i].enemyID == e.enemyID) {
					enemies.splice(i, 1);
					break;
				}
			}
		}
	}
}