package com.geekparty.shooter.view.game.enemies {
	import com.geekparty.shooter.view.game.Bonus;
	import com.geekparty.shooter.view.game.BonusGenerator;
	import com.geekparty.shooter.view.game.BulletGenerator;
	import com.geekparty.shooter.view.game.bullets.PlaneBomb;
	import com.geekparty.shooter.view.game.Enemy;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.filters.ColorMatrixFilter;
	import flash.utils.Timer;
	
	/**
	 * ...
	 * @author Frost
	 */
	public class Plane_1 extends Enemy {
		
		private var layout:UI_enemy_1;
		
		private var speed:Number;
		private var tick:int;
		private var bombTick:Number;
		private var removeCallBack:Function;
		
		private var boom:MovieClip;
		private var dead:MovieClip;
		private var bulletGenerator:BulletGenerator;
		private var bonusGenerator:BonusGenerator;
		
		override public function get addingHeight():int {
			return 100;
		}
		
		override public function getScore():int 
		{
			return 400;
		}
		
		public function Plane_1() {
			layout = new UI_enemy_1();
			boom = layout.getChildByName('boom') as MovieClip;
			dead = layout.getChildByName('dead') as MovieClip;
			addChild(layout);
			speed = 10;
			tick = 0;
			life = 10;
			boom.visible = false;
			dead.visible = false;
			blinkTimer = new Timer(30);
			blinkTimes = blinks;
			blinkTimer.addEventListener(TimerEvent.TIMER, blink);
			
			
			var matrix:Array = new Array();
            matrix=matrix.concat([0.5,0.5,0.5,0,0]);// red
            matrix=matrix.concat([0.5,0.5,0.5,0,0]);// green
            matrix=matrix.concat([0.5,0.5,0.5,0,0]);// blue
            matrix=matrix.concat([0,0,0,1,0]);// alpha
            my_filter=new ColorMatrixFilter(matrix);
		}
		
		private function blink(e:TimerEvent):void {
			if (blinkTimes-- <= 0) {
				blinkTimer.stop();
				blinkTimer.reset();
				blinkTimes = blinks;
				//visible = true;
				return;
			}
			filters = (filters.length == 0) ? [my_filter] : [];
			//visible = !visible;
		}
		
		private static const blinks:int = 4;
		
		private var blinkTimes:int;
		
		public function init(bombTick:Number, removeCallBack:Function, bulletGenerator:BulletGenerator, bonusGenerator:BonusGenerator):void {
			this.bulletGenerator = bulletGenerator;
			this.bonusGenerator = bonusGenerator;
			this.removeCallBack = removeCallBack;
			this.bombTick = bombTick;
			updateRandomThrowTime();
		}
		
		private function updateRandomThrowTime():void {
			bombThrowTime = bombTick + Math.random() * 45;
		}
		
		private var bombThrowTime:Number;
		private var blinkTimer:Timer;
		private var my_filter:ColorMatrixFilter;
		
		override public function move():void {
			tick++;
			if (tick >= bombThrowTime) {
				tick = 0;
				throwBomb();
				updateRandomThrowTime();
			}
			x -= speed;
			if (x < -300) {
				remove();
			}
		}
		
		override public function destroy():void {
			removeCallBack(this);
			boom.visible = true;
			layout.gotoAndStop(1);
			var plane:MovieClip = layout.getChildByName('plane') as MovieClip;
			plane.visible = false;
			dead.visible = true;
			
			boom.gotoAndPlay(1);
			boom.addEventListener(Event.ENTER_FRAME, onFrame);
		}
		
		override public function damage(damage:int):Boolean {
			life -= damage;
			if (life <= 0) {
				return true;
			}
			blinkTimer.start();
			return false;
		}
		
		override public function remove():void {
			removeCallBack(this);
			parent.removeChild(this);
		}
		
		private function onFrame(e:Event):void {
			x -= speed;
			y += 5;
			dead.y += 7;
			alpha -= 0.03;
			if (boom.currentFrame == boom.totalFrames) {
				boom.removeEventListener(Event.ENTER_FRAME, onFrame);
				parent.removeChild(this);
			}
		}
		
		override public function get hit_area():MovieClip {
			return layout;
		}
		
		private function throwBomb():void {
			if (Math.random() < 0.3)
			{

				var b:Bonus = new Bonus(Math.floor(Math.random() * 2));
				b.x = x;
				b.y = y;
				bonusGenerator.generate(b);
			}
			else
			{
			
				var bullet:PlaneBomb = new PlaneBomb();
				bullet.x = x;
				bullet.y = y;
				bulletGenerator.generate(bullet);
			}
		
		}
		
		override public function stop():void {
			layout.gotoAndStop(1);
		}
	}
}