package com.geekparty.shooter.view.screens {
	import com.geekparty.shooter.Main;
	import com.geekparty.shooter.view.components.*;
	import com.geekparty.shooter.view.game.BonusGenerator;
	import com.geekparty.shooter.view.game.BulletGenerator;
	import com.geekparty.shooter.view.game.CloudsGenerator;
	import com.geekparty.shooter.view.game.CollisionDetector;
	import com.geekparty.shooter.view.game.EnemyGenerator;
	import com.geekparty.shooter.view.game.FlyEnemyGenerator;
	import com.geekparty.shooter.view.game.GameOver;
	import com.geekparty.shooter.view.game.Hero;
	import com.geekparty.shooter.view.game.ScoreView;
	import com.geekparty.shooter.view.Screen;
	import flash.display.Bitmap;
	import flash.display.InteractiveObject;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.geom.Point;
	
	/**
	 * ...
	 * @author Frost
	 */
	public class Game extends Screen {
		
		
		
		private var scrollingBackground:ScrollingLayer;
		private var frontWatterLayer:UnderwatterLayer;
		private var wavesLayer:WavesLayer;
		
		private var objectsLayer:Sprite;
		
		private var shaker:Shaker;
		
		private var hero:Hero;
		
		private var flyEnemyGenerator:FlyEnemyGenerator;
		private var enemyGenerator:EnemyGenerator;
		private var cloudsGenerator:CloudsGenerator;
		
		private var collisionDetector:CollisionDetector;
		
		private var bulletGenerator:BulletGenerator;
		private var enemyBulletGenerator:BulletGenerator;
		private var bonusGenerator:BonusGenerator;
		
		
		private var lifesView:LifesView;
		private var scoreView:ScoreView;
		
		public static var tick:int = 0;
		
		public function Game() {
			
		}
		
		override public function get type():int {
			return Screen.TYPE_GAME;
		}
		
		override public function init():void {
			if (initialized) {
				return;
			}
			super.init();
		}
		
		override public function hide():void {
			super.hide();
			
			
			
			removeChild(scrollingBackground);
			removeChild(wavesLayer);
			removeChild(objectsLayer);
			removeChild(frontWatterLayer);
			Main.instance.observer.removeEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		override public function show():void {
			(new pristupim()).play();
		
			
			super.show();
			lifesView = new LifesView();
			scrollingBackground = new ScrollingLayer();
			scrollingBackground.init(3, Assets.back1);
			shaker = new Shaker(this);
			hero = new Hero();
			hero.x = 300;
			hero.y = 500;
			
			tick = 0;
			
			objectsLayer = new Sprite();
			bonusGenerator = new BonusGenerator();
			bonusGenerator.init(objectsLayer);
			
			bulletGenerator = new BulletGenerator();
			bulletGenerator.init(objectsLayer);
			
			enemyBulletGenerator = new BulletGenerator();
			enemyBulletGenerator.init(objectsLayer);
			
			flyEnemyGenerator = new FlyEnemyGenerator();
			flyEnemyGenerator.init(objectsLayer, enemyBulletGenerator, bonusGenerator);
			enemyGenerator = new EnemyGenerator();
			enemyGenerator.init(objectsLayer);
			
			cloudsGenerator = new CloudsGenerator();
			cloudsGenerator.init(objectsLayer);
			
			
			
			wavesLayer = new WavesLayer();
			wavesLayer.y = 600 - 128;
			
			frontWatterLayer = new UnderwatterLayer();
			frontWatterLayer.y = 600 - 95;
			
			scoreView = new ScoreView();
			scoreView.x = 800;
			
			
			hero.init(bulletGenerator, lifesView);
			lifesView.setLifes(hero.life);
			objectsLayer.addChild(hero);
			
			collisionDetector = new CollisionDetector();
			collisionDetector.init(	enemyGenerator.enemies
									, hero
									, shakeScreen
									, bulletGenerator.bullets
									, flyEnemyGenerator.enemies
									, enemyBulletGenerator.bullets
									, scoreView
									, bonusGenerator.bonuses
									);
			
			addChild(scrollingBackground);
			addChild(wavesLayer);
			addChild(objectsLayer);
			addChild(frontWatterLayer);
			addChild(lifesView);
			addChild(scoreView);
			
			
			Main.instance.observer.addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		private var heroMoveSpeed:int = 20;
		
		private function onEnterFrame(e:Event):void {
			tick++;
			scoreView.plus(1);
			if (hero.life <= 0) {
				Main.instance.observer.removeEventListener(Event.ENTER_FRAME, onEnterFrame);
				enemyGenerator.stop();
				var gameOver:GameOver = new GameOver();
				gameOver.setScore(scoreView.score);
				addChild(gameOver);
				hero.die();
				return;
			}
			
			var heroLocalPoint:Point = hero.globalToLocal(new Point(stage.mouseX, stage.mouseY));
			hero.moveHand(heroLocalPoint.x, heroLocalPoint.y);
			if (Main.instance.left) {
				hero.x -= heroMoveSpeed;
				hero.movingBack = true;
				if (hero.x <= 75) {
					hero.x = 75;
				}
			} else {
				hero.movingBack = false;
			}
			if (Main.instance.right) {
				hero.x += heroMoveSpeed;
				if (hero.x >= 725) {
					hero.x = 725;
				}
				if (!hero.jumping) {
					hero.moveRight();
				} 
			} else {
				if (!hero.jumping) {
					hero.stand();
				}
			}
			if (!hero.jumping) {
				if (Main.instance.up) {
					hero.jump(20);
				}
			}
			
			if (Main.instance.mouseDown) {
				hero.shoot();
			}
			
			hero.wave();
			cloudsGenerator.tick();
			
			flyEnemyGenerator.tick();
			enemyGenerator.tick();
			
			
			collisionDetector.tick();
			bulletGenerator.tick();
			bonusGenerator.tick();
			scrollingBackground.move();
			enemyBulletGenerator.tick();
		}
		
		private function shakeScreen():void {
			shaker.shake();
		}
	}
}