





out vec4 vPosition;
in vec4 Position;
//out vec3 Velocity;
const float InverseMaxInt = 1.0 / 4294967295.0;
// curl texture
uniform sampler3D Sampler;

// initial position textures
uniform sampler2D Rendered;
uniform sampler2D RenderedRGB;

uniform float time;
// current vbo position
uniform samplerBuffer TheVBO;



// random function
float randhash(uint seed, float b)
{
    uint i=(seed^12345391u)*2654435769u;
    i^=(i<<6u)^(i>>26u);
    i*=2654435769u;
    i+=(i<<5u)^(i>>12u);
    return float(b * i) * InverseMaxInt;
}


void main()
{


vPosition=Position;



// curl texture
vec3 V= texture(Sampler, (vec3 (-2.5)+vPosition.xyz)*0.01*12*1.0).xyz*1.0;


vec3 MovingV=V*0.003;



// my index
int index=gl_VertexID;


// original position 
float tux=(index%500)/500.0;
float tuy=(index/500)/500.0;

//vec3 TPos=texture2D (Rendered,vec2(tux,tuy)*1.0).xyz;





vPosition.w=1.0;


// reset position 
if (time<0.5) vPosition.xyz=vec3 (randhash (gl_VertexID,1.0),randhash (gl_VertexID+1,1.0),randhash (gl_VertexID+2,1.0));


// fetch arbitrary texel (0th)
vec3 VPos=texelFetch (TheVBO,0).xyz;



// Advance
float DeltaT=1.0;
vPosition.xyz+=DeltaT*MovingV.xyz;

}











