#version 330

precision highp float;

in vec4 vVertex;

uniform sampler2D GOL;
uniform float uTrackTime;
uniform mat4 mvpr;

out vec4 vertColor;

float rand(vec2 co)
{
	return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

/////////////////////////////////////////////////////////////////////////
// Input:	HSVA as vec4 in this order, all numbers in range [0.0,1.0]
// Outpot:	RGBA as vec4 in this order, all numbers in range [0.0,1.0]
vec4 HSVAtoRGBA(vec4 HSVA)
{
	vec4 RGBAreturner;
	RGBAreturner.a = HSVA.w;
	HSVA.x *= 360.0;
	int hi = int((HSVA.x-mod(HSVA.x, 60.0))/60.0);
	float f = HSVA.x/60.0-hi;
	float p = HSVA.z*(1-HSVA.y);
	float q = HSVA.z*(1-HSVA.y*f);
	float t = HSVA.z*(1-HSVA.y*(1-f));
	
	switch(hi) {
	case 0:
	case 6:
		RGBAreturner.rgb = vec3(HSVA.z, t, p);
		break;
	case 1:
		RGBAreturner.rgb = vec3(q, HSVA.z, p);
		break;
	case 2:
		RGBAreturner.rgb = vec3(p, HSVA.z, t);
		break;
	case 3:
		RGBAreturner.rgb = vec3(p, q, HSVA.z);
		break;
	case 4:
		RGBAreturner.rgb = vec3(t, p, HSVA.z);
		break;
	case 5:
		RGBAreturner.rgb = vec3(HSVA.z, p, q);
		break;
	default:
		RGBAreturner.rgb = vec3(0.0);
		break;
	}
	return RGBAreturner;
}

void main(void)
{
    vec2 TXcoord = vec2(vVertex.x*0.5+0.5, vVertex.y*0.5+0.5);  //Fr GOL-Texture
    float golColor = texture(GOL, TXcoord.st).r;
    vec4 HSVA = vec4(0.0);
	
	
	float Tracksecond = uTrackTime-250.0;		//Dauer vom anfang bis zum ersten "effekt"
	float track = step(0.15, mod(Tracksecond/960.0, 1.0));
	track = track*(-1.0)+1.0;

	vec4 myVertex = vVertex;
	
	myVertex.z += (rand(myVertex.xy*vec2(uTrackTime/1000.0))-0.5)*0.05*track;
	
	HSVA = vec4((1.0/6.0)*rand(vVertex.xy*vec2(uTrackTime/1000.0)), 0.85, 0.8, golColor);
	
	gl_Position = mvpr*myVertex;
	vertColor = HSVAtoRGBA(HSVA);
}
