/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;

public class ViewController3D {
    PApplet parent;
    Position pCurr;
    Position pHome;
    double[] mOld;
    double[] mCur;
    double[] mvMatrix;
    double[] prMatrix;
    Mode m_mode;

    ViewController3D(PApplet pApplet) {
        this.parent = pApplet;
        this.pCurr = new Position();
        this.pCurr.c[0] = 0.4778278732493618;
        this.pCurr.c[1] = 0.5015550869020404;
        this.pCurr.c[2] = 0.5668136468921267;
        this.pCurr.d = 6.0;
        this.pHome = new Position();
        this.pHome.c[0] = 0.5;
        this.pHome.c[1] = 0.5;
        this.pHome.c[2] = 0.5;
        this.pHome.d = 1.0;
        this.mOld = new double[2];
        this.mCur = new double[2];
        this.mvMatrix = new double[16];
        this.prMatrix = new double[16];
        this.update();
    }

    void begin(int n, float f, float f2) {
        this.mOld[0] = this.mCur[0] = (double)f;
        this.mOld[1] = this.mCur[1] = (double)f2;
        Mode mode = Mode.NONE;
        if (n == 1) {
            mode = Mode.ROTATE;
        } else if (n == 2) {
            mode = Mode.ZOOM;
        } else if (n == 3) {
            mode = Mode.PAN;
        }
        this.m_mode = mode;
    }

    void move(float f, float f2) {
        this.mCur[0] = f;
        this.mCur[1] = f2;
        switch (this.m_mode) {
            case ROTATE: {
                this.apply_trackball(this.mOld, this.mCur);
                break;
            }
            case ZOOM: {
                double d = 1.0 + (this.mCur[1] - this.mOld[1]);
                if (this.pCurr.d * d > 0.05) {
                    this.pCurr.d *= d;
                    break;
                }
                double[] dArray = new double[]{0.0, 0.0, -(this.mCur[1] - this.mOld[1]) * d};
                this.rotate_vq(dArray, this.pCurr.r);
                this.pCurr.c[0] = this.pCurr.c[0] + dArray[0];
                this.pCurr.c[1] = this.pCurr.c[1] + dArray[1];
                this.pCurr.c[2] = this.pCurr.c[2] + dArray[2];
                break;
            }
            case PUSH: {
                double[] dArray = new double[]{0.0, 0.0, (this.mCur[1] - this.mOld[1]) * this.pCurr.d};
                this.rotate_vq(dArray, this.pCurr.r);
                this.pCurr.c[0] = this.pCurr.c[0] + dArray[0];
                this.pCurr.c[1] = this.pCurr.c[1] + dArray[1];
                this.pCurr.c[2] = this.pCurr.c[2] + dArray[2];
                break;
            }
            case PAN: {
                double[] dArray = new double[]{-0.3 * this.pCurr.d * (this.mCur[0] - this.mOld[0]), -0.3 * this.pCurr.d * (this.mCur[1] - this.mOld[1]), 0.0};
                this.rotate_vq(dArray, this.pCurr.r);
                this.pCurr.c[0] = this.pCurr.c[0] + dArray[0];
                this.pCurr.c[1] = this.pCurr.c[1] + dArray[1];
                this.pCurr.c[2] = this.pCurr.c[2] + dArray[2];
                break;
            }
        }
        this.update();
        this.mOld[0] = this.mCur[0];
        this.mOld[1] = this.mCur[1];
    }

    void end() {
        this.m_mode = Mode.NONE;
    }

    void home(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        dArray[0] = d4 - d;
        dArray[1] = d5 - d2;
        dArray[2] = d6 - d3;
        dArray3[0] = d7;
        dArray3[1] = d8;
        dArray3[2] = d9;
        this.pCurr.c[0] = d4;
        this.pCurr.c[1] = d5;
        this.pCurr.c[2] = d6;
        this.pCurr.d = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        if (this.pCurr.d != 0.0) {
            dArray[0] = dArray[0] / this.pCurr.d;
            dArray[1] = dArray[1] / this.pCurr.d;
            dArray[2] = dArray[2] / this.pCurr.d;
        }
        dArray2[0] = dArray[1] * dArray3[2] - dArray[2] * dArray3[1];
        dArray2[1] = dArray[2] * dArray3[0] - dArray[0] * dArray3[2];
        dArray2[2] = dArray[0] * dArray3[1] - dArray[1] * dArray3[0];
        double d10 = Math.sqrt(dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1] + dArray2[2] * dArray2[2]);
        dArray2[0] = dArray2[0] / d10;
        dArray2[1] = dArray2[1] / d10;
        dArray2[2] = dArray2[2] / d10;
        Math.sqrt(dArray3[0] * dArray3[0] + dArray3[1] * dArray3[1] + dArray3[2] * dArray3[2]);
        dArray3[0] = dArray2[1] * dArray[2] - dArray2[2] * dArray[1];
        dArray3[1] = dArray2[2] * dArray[0] - dArray2[0] * dArray[2];
        dArray3[2] = dArray2[0] * dArray[1] - dArray2[1] * dArray[0];
        double[][] dArrayArray = new double[][]{{0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}};
        dArrayArray[0][0] = dArray2[0];
        dArrayArray[1][0] = dArray2[1];
        dArrayArray[2][0] = dArray2[2];
        dArrayArray[0][1] = dArray3[0];
        dArrayArray[1][1] = dArray3[1];
        dArrayArray[2][1] = dArray3[2];
        dArrayArray[0][2] = -dArray[0];
        dArrayArray[1][2] = -dArray[1];
        dArrayArray[2][2] = -dArray[2];
        double[] dArray4 = new double[]{1.0 + dArrayArray[0][0] + dArrayArray[1][1] - dArray[2], 1.0 + dArrayArray[0][0] - dArrayArray[1][1] + dArray[2], 1.0 - dArrayArray[0][0] + dArrayArray[1][1] + dArray[2], 1.0 - dArrayArray[0][0] - dArrayArray[1][1] - dArray[2]};
        int n = 0;
        int n2 = 1;
        while (n2 < 4) {
            if (dArray4[n2] > dArray4[n]) {
                n = n2;
            }
            ++n2;
        }
        double d11 = 0.5 * Math.sqrt(1.0 / dArray4[n]);
        if (n == 0) {
            this.pCurr.r[0] = d11 * (dArrayArray[1][2] - dArrayArray[2][1]);
            this.pCurr.r[1] = d11 * (dArrayArray[2][0] - dArrayArray[0][2]);
            this.pCurr.r[2] = d11 * (dArrayArray[0][1] - dArrayArray[1][0]);
            this.pCurr.r[3] = d11 * dArray4[0];
        } else if (n == 1) {
            this.pCurr.r[0] = d11 * dArray4[1];
            this.pCurr.r[1] = d11 * (dArrayArray[0][1] + dArrayArray[1][0]);
            this.pCurr.r[2] = d11 * (dArrayArray[2][0] + dArrayArray[0][2]);
            this.pCurr.r[3] = d11 * (dArrayArray[1][2] - dArrayArray[2][1]);
        } else if (n == 2) {
            this.pCurr.r[0] = d11 * (dArrayArray[0][1] + dArrayArray[1][0]);
            this.pCurr.r[1] = d11 * dArray4[2];
            this.pCurr.r[2] = d11 * (dArrayArray[1][2] + dArrayArray[2][1]);
            this.pCurr.r[3] = d11 * (dArrayArray[2][0] - dArrayArray[0][2]);
        } else {
            this.pCurr.r[0] = d11 * (dArrayArray[2][0] + dArrayArray[0][2]);
            this.pCurr.r[1] = d11 * (dArrayArray[1][2] + dArrayArray[2][1]);
            this.pCurr.r[2] = d11 * dArray4[3];
            this.pCurr.r[3] = d11 * (dArrayArray[0][1] - dArrayArray[1][0]);
        }
        this.pHome = new Position(this.pCurr);
        this.update();
    }

    void home() {
        this.pCurr = new Position(this.pHome);
        this.update();
    }

    void apply_trackball(double[] dArray, double[] dArray2) {
        double d = dArray[0] * dArray[0] + dArray[1] * dArray[1];
        double d2 = dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1];
        double[] dArray3 = new double[]{dArray[0], dArray[1], d < 0.8 ? Math.sqrt(1.6 - d) : 0.8 / Math.sqrt(d)};
        double[] dArray4 = new double[]{dArray2[0], dArray2[1], d2 < 0.8 ? Math.sqrt(1.6 - d2) : 0.8 / Math.sqrt(d2)};
        double[] dArray5 = new double[]{dArray4[1] * dArray3[2] - dArray4[2] * dArray3[1], dArray4[2] * dArray3[0] - dArray4[0] * dArray3[2], dArray4[0] * dArray3[1] - dArray4[1] * dArray3[0]};
        double[] dArray6 = new double[]{dArray5[0], dArray5[1], dArray5[2]};
        this.normalize(dArray5);
        this.rotate_vq(dArray5, this.pCurr.r);
        dArray4[0] = dArray4[0] - dArray3[0];
        dArray4[1] = dArray4[1] - dArray3[1];
        dArray4[2] = dArray4[2] - dArray3[2];
        double d3 = Math.sqrt(dArray4[0] * dArray4[0] + dArray4[1] * dArray4[1] + dArray4[2] * dArray4[2]) / 0.8;
        if (d3 > 1.0) {
            d3 = 1.0;
        }
        if (d3 < -1.0) {
            d3 = -1.0;
        }
        d3 = Math.asin(d3);
        double d4 = Math.cos(0.5 * d3);
        double d5 = Math.sin(0.5 * d3);
        double[] dArray7 = new double[]{dArray5[0] * d5, dArray5[1] * d5, dArray5[2] * d5, d4};
        this.rotate_qq(this.pCurr.r, dArray7);
    }

    void rotate_vq(double[] dArray, double[] dArray2) {
        double d = 2.0 * dArray2[0] * dArray2[0];
        double d2 = 2.0 * dArray2[0] * dArray2[1];
        double d3 = 2.0 * dArray2[0] * dArray2[2];
        double d4 = 2.0 * dArray2[1] * dArray2[1];
        double d5 = 2.0 * dArray2[1] * dArray2[2];
        double d6 = 2.0 * dArray2[2] * dArray2[2];
        double d7 = 2.0 * dArray2[3] * dArray2[0];
        double d8 = 2.0 * dArray2[3] * dArray2[1];
        double d9 = 2.0 * dArray2[3] * dArray2[2];
        double[] dArray3 = new double[]{dArray[0], dArray[1], dArray[2]};
        dArray[0] = (1.0 - d4 - d6) * dArray3[0] + (d2 - d9) * dArray3[1] + (d3 + d8) * dArray3[2];
        dArray[1] = (d2 + d9) * dArray3[0] + (1.0 - d - d6) * dArray3[1] + (d5 - d7) * dArray3[2];
        dArray[2] = (d3 - d8) * dArray3[0] + (d5 + d7) * dArray3[1] + (1.0 - d - d4) * dArray3[2];
    }

    void rotate_qq(double[] dArray, double[] dArray2) {
        double d = dArray2[3] * dArray[0] + dArray2[0] * dArray[3] + dArray2[1] * dArray[2] - dArray2[2] * dArray[1];
        double d2 = dArray2[3] * dArray[1] - dArray2[0] * dArray[2] + dArray2[1] * dArray[3] + dArray2[2] * dArray[0];
        double d3 = dArray2[3] * dArray[2] + dArray2[0] * dArray[1] - dArray2[1] * dArray[0] + dArray2[2] * dArray[3];
        double d4 = dArray2[3] * dArray[3] - dArray2[0] * dArray[0] - dArray2[1] * dArray[1] - dArray2[2] * dArray[2];
        dArray[0] = d;
        dArray[1] = d2;
        dArray[2] = d3;
        dArray[3] = d4;
    }

    void normalize(double[] dArray) {
        double d = dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2];
        if (d != 0.0) {
            d = Math.sqrt(d);
            dArray[0] = dArray[0] / d;
            dArray[1] = dArray[1] / d;
            dArray[2] = dArray[2] / d;
        }
    }

    void update() {
        this.mvMatrix[0] = 1.0 - 2.0 * this.pCurr.r[1] * this.pCurr.r[1] - 2.0 * this.pCurr.r[2] * this.pCurr.r[2];
        this.mvMatrix[1] = 2.0 * this.pCurr.r[0] * this.pCurr.r[1] - 2.0 * this.pCurr.r[2] * this.pCurr.r[3];
        this.mvMatrix[2] = 2.0 * this.pCurr.r[0] * this.pCurr.r[2] + 2.0 * this.pCurr.r[1] * this.pCurr.r[3];
        this.mvMatrix[3] = 0.0;
        this.mvMatrix[4] = 2.0 * this.pCurr.r[0] * this.pCurr.r[1] + 2.0 * this.pCurr.r[2] * this.pCurr.r[3];
        this.mvMatrix[5] = 1.0 - 2.0 * this.pCurr.r[0] * this.pCurr.r[0] - 2.0 * this.pCurr.r[2] * this.pCurr.r[2];
        this.mvMatrix[6] = 2.0 * this.pCurr.r[1] * this.pCurr.r[2] - 2.0 * this.pCurr.r[0] * this.pCurr.r[3];
        this.mvMatrix[7] = 0.0;
        this.mvMatrix[8] = 2.0 * this.pCurr.r[0] * this.pCurr.r[2] - 2.0 * this.pCurr.r[1] * this.pCurr.r[3];
        this.mvMatrix[9] = 2.0 * this.pCurr.r[1] * this.pCurr.r[2] + 2.0 * this.pCurr.r[0] * this.pCurr.r[3];
        this.mvMatrix[10] = 1.0 - 2.0 * this.pCurr.r[0] * this.pCurr.r[0] - 2.0 * this.pCurr.r[1] * this.pCurr.r[1];
        this.mvMatrix[11] = 0.0;
        this.mvMatrix[12] = -(this.mvMatrix[0] * this.pCurr.c[0] + this.mvMatrix[4] * this.pCurr.c[1] + this.mvMatrix[8] * this.pCurr.c[2]);
        this.mvMatrix[13] = -(this.mvMatrix[1] * this.pCurr.c[0] + this.mvMatrix[5] * this.pCurr.c[1] + this.mvMatrix[9] * this.pCurr.c[2]);
        this.mvMatrix[14] = -(this.mvMatrix[2] * this.pCurr.c[0] + this.mvMatrix[6] * this.pCurr.c[1] + this.mvMatrix[10] * this.pCurr.c[2] + this.pCurr.d);
        this.mvMatrix[15] = 1.0;
        double d = 100.0;
        double d2 = 0.1;
        double d3 = 2.414213562;
        double d4 = (double)this.parent.width / (double)this.parent.height;
        this.prMatrix[0] = d3 / d4;
        this.prMatrix[1] = 0.0;
        this.prMatrix[2] = 0.0;
        this.prMatrix[3] = 0.0;
        this.prMatrix[4] = 0.0;
        this.prMatrix[5] = d3;
        this.prMatrix[6] = 0.0;
        this.prMatrix[7] = 0.0;
        this.prMatrix[8] = 0.0;
        this.prMatrix[9] = 0.0;
        this.prMatrix[10] = (d + d2) / (d2 - d);
        this.prMatrix[11] = -1.0;
        this.prMatrix[12] = 0.0;
        this.prMatrix[13] = 0.0;
        this.prMatrix[14] = 2.0 * d * d2 / (d2 - d);
        this.prMatrix[15] = 0.0;
    }

    static enum Mode {
        NONE,
        ROTATE,
        ROTATE_Z,
        PAN,
        ZOOM,
        PUSH;

    }

    class Position {
        double[] r;
        double[] c;
        double d;

        Position() {
            this.r = new double[]{0.0, 0.0, 0.0, 1.0};
            this.c = new double[]{0.0, 0.0, 0.0};
            this.d = 1.0;
        }

        Position(Position position) {
            this.r = new double[]{position.r[0], position.r[1], position.r[2], position.r[3]};
            this.c = new double[]{position.c[0], position.c[1], position.c[2]};
            this.d = position.d;
        }
    }
}

