/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.gluegen.runtime.ProcAddressTable;
import com.jogamp.gluegen.runtime.opengl.GLProcAddressResolver;
import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Map;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.egl.EGL;
import jogamp.opengl.egl.EGLExt;
import jogamp.opengl.egl.EGLExtImpl;
import jogamp.opengl.egl.EGLExtProcAddressTable;
import jogamp.opengl.egl.EGLGraphicsConfiguration;

public class EGLContext
extends GLContextImpl {
    private boolean eglQueryStringInitialized;
    private boolean eglQueryStringAvailable;
    private EGLExt _eglExt;
    private EGLExtProcAddressTable eglExtProcAddressTable;

    EGLContext(GLDrawableImpl gLDrawableImpl, GLContext gLContext) {
        super(gLDrawableImpl, gLContext);
    }

    @Override
    protected void resetStates() {
        this.eglQueryStringInitialized = false;
        this.eglQueryStringAvailable = false;
        this.eglExtProcAddressTable = null;
        super.resetStates();
    }

    @Override
    public Object getPlatformGLExtensions() {
        return this.getEGLExt();
    }

    public EGLExt getEGLExt() {
        if (this._eglExt == null) {
            this._eglExt = new EGLExtImpl(this);
        }
        return this._eglExt;
    }

    @Override
    public final ProcAddressTable getPlatformExtProcAddressTable() {
        return this.eglExtProcAddressTable;
    }

    public final EGLExtProcAddressTable getEGLExtProcAddressTable() {
        return this.eglExtProcAddressTable;
    }

    @Override
    protected Map<String, String> getFunctionNameMap() {
        return null;
    }

    @Override
    protected Map<String, String> getExtensionNameMap() {
        return null;
    }

    @Override
    public final boolean isGLReadDrawableAvailable() {
        return true;
    }

    @Override
    protected void makeCurrentImpl() throws GLException {
        long l;
        if (EGL.eglGetCurrentContext() != this.contextHandle && !EGL.eglMakeCurrent(l = this.drawable.getNativeSurface().getDisplayHandle(), this.drawable.getHandle(), this.drawableRead.getHandle(), this.contextHandle)) {
            throw new GLException("Error making context " + EGLContext.toHexString(this.contextHandle) + " current on Thread " + EGLContext.getThreadName() + " with display " + EGLContext.toHexString(l) + ", drawableWrite " + EGLContext.toHexString(this.drawable.getHandle()) + ", drawableRead " + EGLContext.toHexString(this.drawableRead.getHandle()) + " - Error code " + EGLContext.toHexString(EGL.eglGetError()) + ", " + this);
        }
    }

    @Override
    protected void releaseImpl() throws GLException {
        if (!EGL.eglMakeCurrent(this.drawable.getNativeSurface().getDisplayHandle(), 0L, 0L, 0L)) {
            throw new GLException("Error freeing OpenGL context " + EGLContext.toHexString(this.contextHandle) + ": error code " + EGLContext.toHexString(EGL.eglGetError()));
        }
    }

    @Override
    protected void destroyImpl() throws GLException {
        int n;
        if (!EGL.eglDestroyContext(this.drawable.getNativeSurface().getDisplayHandle(), this.contextHandle) && 12288 != (n = EGL.eglGetError())) {
            throw new GLException("Error destroying OpenGL context " + EGLContext.toHexString(this.contextHandle) + ": error code " + EGLContext.toHexString(n));
        }
    }

    @Override
    protected long createContextARBImpl(long l, boolean bl, int n, int n2, int n3) {
        return 0L;
    }

    @Override
    protected void destroyContextARBImpl(long l) {
    }

    @Override
    protected boolean createImpl(GLContextImpl gLContextImpl) throws GLException {
        long l;
        long l2;
        GLProfile gLProfile;
        long l3;
        EGLGraphicsConfiguration eGLGraphicsConfiguration;
        block13: {
            eGLGraphicsConfiguration = (EGLGraphicsConfiguration)this.drawable.getNativeSurface().getGraphicsConfiguration();
            l3 = eGLGraphicsConfiguration.getScreen().getDevice().getHandle();
            gLProfile = this.drawable.getGLProfile();
            l2 = eGLGraphicsConfiguration.getNativeConfig();
            l = 0L;
            if (0L == l3) {
                throw new GLException("Error: attempted to create an OpenGL context without a display connection");
            }
            if (0L == l2) {
                throw new GLException("Error: attempted to create an OpenGL context without a graphics configuration");
            }
            try {
                if (!EGL.eglBindAPI(12448)) {
                    throw new GLException("Catched: eglBindAPI to ES failed , error " + EGLContext.toHexString(EGL.eglGetError()));
                }
            }
            catch (GLException gLException) {
                if (!DEBUG) break block13;
                gLException.printStackTrace();
            }
        }
        if (gLContextImpl != null && (l = gLContextImpl.getHandle()) == 0L) {
            throw new GLException("GLContextShareSet returned an invalid OpenGL context");
        }
        int[] nArray = new int[]{12440, -1, 12344};
        if (gLProfile.usesNativeGLES2()) {
            nArray[1] = 2;
        } else if (gLProfile.usesNativeGLES1()) {
            nArray[1] = 1;
        } else {
            throw new GLException("Error creating OpenGL context - invalid GLProfile: " + gLProfile);
        }
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int[])nArray);
        this.contextHandle = EGL.eglCreateContext(l3, l2, l, intBuffer);
        if (this.contextHandle == 0L) {
            throw new GLException("Error creating OpenGL context: eglDisplay " + EGLContext.toHexString(l3) + ", eglConfig " + eGLGraphicsConfiguration + ", " + gLProfile + ", shareWith " + EGLContext.toHexString(l) + ", error " + EGLContext.toHexString(EGL.eglGetError()));
        }
        if (DEBUG) {
            System.err.println(EGLContext.getThreadName() + ": Created OpenGL context 0x" + Long.toHexString(this.contextHandle) + ",\n\twrite surface 0x" + Long.toHexString(this.drawable.getHandle()) + ",\n\tread  surface 0x" + Long.toHexString(this.drawableRead.getHandle()) + ",\n\t" + this + ",\n\tsharing with 0x" + Long.toHexString(l));
        }
        if (!EGL.eglMakeCurrent(l3, this.drawable.getHandle(), this.drawableRead.getHandle(), this.contextHandle)) {
            throw new GLException("Error making context " + EGLContext.toHexString(this.contextHandle) + " current: error code " + EGLContext.toHexString(EGL.eglGetError()));
        }
        this.setGLFunctionAvailability(true, gLProfile.usesNativeGLES2() ? 2 : 1, 0, 8, false);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void updateGLXProcAddressTable() {
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        String string = "EGL-" + abstractGraphicsDevice.getUniqueID();
        if (DEBUG) {
            System.err.println(EGLContext.getThreadName() + ": Initializing EGLextension address table: " + string);
        }
        this.eglQueryStringInitialized = false;
        this.eglQueryStringAvailable = false;
        ProcAddressTable procAddressTable = null;
        Object object = mappedContextTypeObjectLock;
        synchronized (object) {
            procAddressTable = (ProcAddressTable)mappedGLXProcAddress.get(string);
        }
        if (null != procAddressTable) {
            this.eglExtProcAddressTable = (EGLExtProcAddressTable)procAddressTable;
            if (DEBUG) {
                System.err.println(EGLContext.getThreadName() + ": GLContext EGL ProcAddressTable reusing key(" + string + ") -> " + EGLContext.toHexString(procAddressTable.hashCode()));
            }
        } else {
            this.eglExtProcAddressTable = new EGLExtProcAddressTable(new GLProcAddressResolver());
            this.resetProcAddressTable(this.getEGLExtProcAddressTable());
            object = mappedContextTypeObjectLock;
            synchronized (object) {
                mappedGLXProcAddress.put(string, this.getEGLExtProcAddressTable());
                if (DEBUG) {
                    System.err.println(EGLContext.getThreadName() + ": GLContext EGL ProcAddressTable mapping key(" + string + ") -> " + EGLContext.toHexString(((Object)((Object)this.getEGLExtProcAddressTable())).hashCode()));
                }
            }
        }
    }

    @Override
    protected final StringBuilder getPlatformExtensionsStringImpl() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.eglQueryStringInitialized) {
            this.eglQueryStringAvailable = this.getDrawableImpl().getGLDynamicLookupHelper().dynamicLookupFunction("eglQueryString") != 0L;
            this.eglQueryStringInitialized = true;
        }
        if (this.eglQueryStringAvailable) {
            String string = EGL.eglQueryString(this.drawable.getNativeSurface().getDisplayHandle(), 12373);
            if (DEBUG) {
                System.err.println("EGL extensions: " + string);
            }
            stringBuilder.append(string);
        }
        return stringBuilder;
    }

    @Override
    protected boolean setSwapIntervalImpl(int n) {
        if (this.hasRendererQuirk(2)) {
            return false;
        }
        return EGL.eglSwapInterval(this.drawable.getNativeSurface().getDisplayHandle(), n);
    }

    void mapCurrentAvailableGLVersion(AbstractGraphicsDevice abstractGraphicsDevice) {
        EGLContext.mapStaticGLVersion(abstractGraphicsDevice, this.ctxVersion.getMajor(), this.ctxVersion.getMinor(), this.ctxOptions);
    }

    int getContextOptions() {
        return this.ctxOptions;
    }

    static void mapStaticGLESVersion(AbstractGraphicsDevice abstractGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        int[] nArray = new int[2];
        GLContext.getRequestMajorAndCompat(gLProfile, nArray);
        if (gLProfile.isGLES() && nArray[0] >= 2) {
            nArray[1] = nArray[1] | 0x300;
        }
        if (!gLCapabilitiesImmutable.getHardwareAccelerated()) {
            nArray[1] = nArray[1] | 0x8000;
        }
        EGLContext.mapStaticGLVersion(abstractGraphicsDevice, nArray[0], 0, nArray[1]);
    }

    static void mapStaticGLESVersion(AbstractGraphicsDevice abstractGraphicsDevice, int n) {
        int n2 = 2 == n ? 776 : 8;
        EGLContext.mapStaticGLVersion(abstractGraphicsDevice, n, 0, n2);
    }

    static void mapStaticGLVersion(AbstractGraphicsDevice abstractGraphicsDevice, int n, int n2, int n3) {
        if (0 != (n3 & 8)) {
            int n4 = n;
            GLContext.mapAvailableGLVersion(abstractGraphicsDevice, n4, 8, n, n2, n3);
            if (!(abstractGraphicsDevice instanceof EGLGraphicsDevice)) {
                EGLGraphicsDevice eGLGraphicsDevice = new EGLGraphicsDevice(abstractGraphicsDevice.getHandle(), 0L, abstractGraphicsDevice.getConnection(), abstractGraphicsDevice.getUnitID(), null);
                GLContext.mapAvailableGLVersion(eGLGraphicsDevice, n4, 8, n, n2, n3);
            }
        }
    }

    protected static String getGLVersion(int n, int n2, int n3, String string) {
        return GLContext.getGLVersion(n, n2, n3, string);
    }

    protected static boolean getAvailableGLVersionsSet(AbstractGraphicsDevice abstractGraphicsDevice) {
        return GLContext.getAvailableGLVersionsSet(abstractGraphicsDevice);
    }

    protected static void setAvailableGLVersionsSet(AbstractGraphicsDevice abstractGraphicsDevice) {
        GLContext.setAvailableGLVersionsSet(abstractGraphicsDevice);
    }

    protected static String toHexString(int n) {
        return GLContext.toHexString(n);
    }

    protected static String toHexString(long l) {
        return GLContext.toHexString(l);
    }

    @Override
    protected void copyImpl(GLContext gLContext, int n) throws GLException {
        throw new GLException("Not yet implemented");
    }

    @Override
    public ByteBuffer glAllocateMemoryNV(int n, float f, float f2, float f3) {
        throw new GLException("Should not call this");
    }
}

