#include <rasterizerStates.fx>
#include <blendStates.fx>
#include <depthStencilStates.fx>
float4x4 modelMatrix;
float4x4 modelMatrixInverse;
float4x4 modelViewProjMatrix;


SamplerState linearSampler
{
Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};


float3 lightPos = float3(0, 0, 0);
float3 lightPower = 
		float3(5000, 5000, 5000);
float3 kd = float3((232.0/255), (63.0/255.0), (207.0/255.0)); 
float3 envKd = 1;
float3 grayMatter = 0;
float3 eyePos;
float3 visible = 0;
float3 ks = float3(10,10,10);
float1 n = 20; 
float3 timeDT = 0;
TextureCube envTexture;

float3 lightPos2 = float3(0, 0, 0);
float3 lightPower2 = 
		float3(500, 500, 500);
struct IaosBillboard
{
    float3 pos : POSITION;
    float lifespan : LIFESPAN;
    float age : AGE;
};

typedef IaosBillboard VsosBillboard;

VsosBillboard vsBillboard(IaosBillboard input)
{
    return input;
}

struct GsosBillboard
{
    float4 pos : SV_Position;
    float2 tex : TEXCOORD;
    float opacity : OPACITY;
};

float billboardWidth = 0.1;
float billboardHeight = 0.1;

[maxvertexcount(4)]
void gsBillboard(point VsosBillboard input[1], inout TriangleStream<GsosBillboard> stream) {
	float4 hndcPos = mul(float4(input[0].pos, 1), modelViewProjMatrix);
	GsosBillboard output;

	float s = input[0].age / input[0].lifespan;
	output.opacity = 1 - abs(s*2-1);

	output.pos = hndcPos;
	output.pos.x += billboardWidth	*s;
	output.pos.y += billboardHeight	*s;
	output.tex = float2(1, 0);
	stream.Append(output);
	output.pos = hndcPos;
	output.pos.x += billboardWidth	*s;
	output.pos.y -= billboardHeight *s;
	output.tex = float2(1, 1);
	stream.Append(output);
	output.pos = hndcPos;
	output.pos.x -= billboardWidth  *s;
	output.pos.y += billboardHeight *s;
	output.tex = float2(0, 0);
	stream.Append(output);
	output.pos = hndcPos;
	output.pos.x -= billboardWidth  *s;
	output.pos.y -= billboardHeight *s;
	output.tex = float2(0, 1);
	stream.Append(output);
}

Texture2D billboardTexture;

float4 psFire(GsosBillboard input) : SV_Target
{
	float4 color = billboardTexture.Sample(linearSampler, input.tex.xy);
	color.rgb = float3( color.a,
		pow(color.a, 4),
		pow(color.a, 10));
	color.a *= input.opacity * 0.1;
	return color;
}


technique11 billboard {
	pass fire {
		SetVertexShader ( 
			CompileShader( vs_5_0, vsBillboard() ) );
		SetGeometryShader ( 
			CompileShader( gs_5_0, gsBillboard() ) );
		SetRasterizerState( defaultRasterizer );
		SetPixelShader( 
			CompileShader( ps_5_0, psFire() ) );
		SetDepthStencilState( noDepthWriteCompositor, 0 );
		SetBlendState( transparencyBlender, 
			float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF  );
	}
}

struct IaosTrafo
{
    float4 pos	: POSITION;
    float3 normal 	: NORMAL;
   // float2 tex 	: TEXCOORD;
       float4x4 instanceModelMatrix: INSTANCEMODEL;

};

struct IaosTrafoTextured
{
    float4 pos	: POSITION;
    float3 normal 	: NORMAL;
	float2 tex 	: TEXCOORD;

};
struct VsosTrafoTextured
{
    float4 pos 		: SV_POSITION;
    float4 worldPos 	: WORLDPOS;
    float3 normal 		: NORMAL;
    float2 tex 		: TEXCOORD;
};
struct IaosTrafoBasic
{
    float4 pos	: POSITION;
    float3 normal 	: NORMAL;
   // float2 tex 	: TEXCOORD;

};
struct VsosTrafo
{
    float4 pos 		: SV_POSITION;
    float4 worldPos 	: WORLDPOS;
    float3 normal 		: NORMAL;
 //   float2 tex 		: TEXCOORD;
};

VsosTrafo vsTrafo(IaosTrafoBasic input)
{
	VsosTrafo output = (VsosTrafo)0;
	
	output.pos = mul(input.pos,modelViewProjMatrix);
	output.worldPos = mul(input.pos,modelMatrix);
	output.normal = mul(modelMatrixInverse,
		float4(input.normal.xyz, 0.0));
/*	output.tex = input.tex;*/
	return output;
}

VsosTrafoTextured vsTrafoTextured(IaosTrafoTextured input)
{
	VsosTrafoTextured output = (VsosTrafoTextured)0;
	
	output.pos = mul(input.pos,modelViewProjMatrix);
	output.worldPos = mul(input.pos,modelMatrix);
	output.normal = mul(modelMatrixInverse,
		float4(input.normal.xyz, 0.0));
	output.tex = input.tex;
	return output;
}
VsosTrafo vsTrafoInstanced(IaosTrafo input)
{
	VsosTrafo output = (VsosTrafo)0;
	
	output.worldPos = mul(input.pos,
		input.instanceModelMatrix);
		output.pos = mul(output.worldPos,modelViewProjMatrix);
	output.normal = mul(modelMatrixInverse,
		float4(input.normal.xyz, 0.0));
/*	output.tex = input.tex;*/
	return output;
}

float4 psBasicBox(VsosTrafo input) : SV_Target
{
float3 normal = normalize(input.normal);
	float3 toLight = lightPos - input.worldPos.xyz;
	float3 lightDist2 = dot(toLight, toLight);
	float3 lightDir = normalize(toLight);
	float3 toEye = eyePos - input.worldPos.xyz;
	float3 viewDir = normalize(toEye);
	return float4(
		(float3(0.2,0.2,0.2) * saturate(dot(lightDir, normal))),1);
		

}
Texture2D Texture;
float4 psBasicTextured(VsosTrafoTextured input) : SV_Target
{
float3 normal = normalize(input.normal);
	float3 toLight = lightPos - input.worldPos.xyz;
	float3 lightDist2 = dot(toLight, toLight);
	float3 lightDir = normalize(toLight);
	float3 toEye = eyePos - input.worldPos.xyz;
	float3 viewDir = normalize(toEye);
		  return float4( Texture.Sample(linearSampler, input.tex)
		  * saturate(dot(lightDir,normal)) +
		  ks * pow(saturate(dot(reflect(-viewDir,normal),lightDir)),n),visible.x) ;
}
float4 psBasic(VsosTrafo input) : SV_Target
{
float3 normal = normalize(input.normal);
	float3 toLight = lightPos - input.worldPos.xyz;
	float3 lightDist2 = dot(toLight, toLight);
	float3 lightDir = normalize(toLight);
	float3 toEye = eyePos - input.worldPos.xyz;
	float3 viewDir = normalize(toEye);
	return float4(
		(kd * saturate(dot(lightDir, normal))
		+ ks * pow(
			saturate(dot(
				reflect(-viewDir, normal),
				lightDir)), n) )
		* lightPower 
		/ (4 * 3.14 * lightDist2), 1);

}
float4 psBasicEnvMapped(VsosTrafo input) : SV_Target
{
	 float3 normal = normalize(input.normal);
float3 toLight = lightPos -
		input.worldPos.xyz;
float3 lightDist2 = dot(toLight, toLight);
float3 lightDir = normalize(toLight);

float3 viewDir = normalize(input.worldPos - eyePos);
	float3 reflectionDir = reflect(viewDir, input.normal);


return    float4(
		0.008 * envTexture.Sample(linearSampler, reflectionDir));
		/*   saturate(dot(lightDir, normal)) * lightPower / (4 * 3.14 * lightDist2), 1);*/

}
float4 psBasicInstancedEnvMapped(VsosTrafo input) : SV_Target
{
	 float3 normal = normalize(input.normal);
float3 toLight = lightPos -
		input.worldPos.xyz;
float3 lightDist2 = dot(toLight, toLight);
float3 lightDir = normalize(toLight);

float3 viewDir = normalize(input.worldPos - eyePos);
	float3 reflectionDir = reflect(viewDir, input.normal);


return float4(
		envKd.x * envTexture.Sample(linearSampler, reflectionDir));
		/*   saturate(dot(lightDir, normal)) * lightPower / (4 * 3.14 * lightDist2), 1);*/

}
float4 psBasicInstanced(VsosTrafo input) : SV_Target
{
	 float3 normal = normalize(input.normal);
float3 toLight = lightPos -
		input.worldPos.xyz;
float3 lightDist2 = dot(toLight, toLight);
float3 lightDir = normalize(toLight);

float3 viewDir = normalize(input.worldPos - eyePos);
	float3 reflectionDir = reflect(viewDir, input.normal);


return float4(
		( kd * 1.0 + 
		0.0 * envTexture.Sample(linearSampler, reflectionDir))  * 
		saturate(dot(lightDir, normal))
		* lightPower / (4 * 3.14 * lightDist2)
		,1);

}



struct IaosQuad
{
	float4  pos: POSITION;
	float2  tex: TEXCOORD0;
};

struct VsosQuad
{
	float4 pos: SV_POSITION;
	float2 tex: TEXCOORD0;
	float3 viewDir: TEXCOORD1;
};

float4x4 viewDirMatrix;

VsosQuad vsQuad(IaosQuad input)
{
	VsosQuad output = (VsosQuad)0;

	output.pos = input.pos;
  float4 hWorldPosMinusEye = mul(input.pos, 	viewDirMatrix);
  output.viewDir = hWorldPosMinusEye.xyz;
	output.tex = input.tex;
  return output;
}

float4 psBackground(VsosQuad input) : SV_Target
{
return envTexture.Sample(linearSampler, input.viewDir);
}
Texture2D postProcTexture;
float4 psBlur(VsosQuad input) : SV_Target0
{
	float1 strength = 0.01;
	return (
		  postProcTexture.Sample(linearSampler, input.tex) *1.5 
		+ 		postProcTexture.Sample(linearSampler, input.tex + float2(+strength, +0.00) * 1.5) * 0.7
		+ 		postProcTexture.Sample(linearSampler, input.tex + float2(+strength, +strength) * 1.5) * 0.7
		+ 		postProcTexture.Sample(linearSampler, input.tex + float2(+0.00, +strength) * 1.5) * 0.7
		+ 		postProcTexture.Sample(linearSampler, input.tex + float2(-strength, +strength) * 1.5) * 0.7
		+ 		postProcTexture.Sample(linearSampler, input.tex + float2(-strength, +0.00) * 1.5) * 0.7
		+ 		postProcTexture.Sample(linearSampler, input.tex + float2(-strength, -strength) * 1.5) * 0.7
		+ 		postProcTexture.Sample(linearSampler, input.tex + float2(+0.00, -strength) * 1.5) * 0.7
		+ 		postProcTexture.Sample(linearSampler, input.tex + float2(+strength, -strength) * 1.5) * 0.7

		);
}
float4 psGray(VsosQuad input) : SV_TARGET0
{
	float3 col = postProcTexture.Sample(linearSampler,input.tex);
	return float4(lerp(col,((col.x + col.y + col.z) / 3),grayMatter.x),1);


}

float4 psWave(VsosQuad input) : SV_TARGET0
{
        float1 k = -1.0;
       
        // cubic distortion value
        float kcube = 0.0;
       
       
        float1 r2 = (input.tex.x-0.5) * (input.tex.x-0.5) + 
					(input.tex.y-0.5) * (input.tex.y-0.5);       


        float1 f = 0;
       
 
        //only compute the cubic distortion if necessary
        if( kcube == 0.0){
                f = 1 + r2 * k;
        }else{
                f = 1 + r2 * (k + kcube * sqrt(r2));
        };
       
        // get the right pixel for the current position
        float1 x = f*(input.tex.x-0.5)+0.5;
        float1 y = f*(input.tex.y-0.5)+0.5;
        float2 inputDistord = float2(x,y);
		return postProcTexture.Sample(linearSampler,inputDistord); 
 
/*
	float4 strength = float4(0.01,0.01,0.01,0.01);
	float2 posDist = float2(input.tex.x * strength.x + input.tex.y * strength.y,
						     input.tex.x * strength.z + input.tex.y * strength.w);
	float2 angles = float2(posDist.x + timeDT.x * 6.28,
							posDist.y + timeDT.x * 6.28);
	float2 distortion = float2(cos(angles.x),sin(angles.y));
	return postProcTexture.Sample(linearSampler,input.tex + distortion);
		*/				

}
float4 psGrayEdge(VsosQuad input) : SV_TARGET0
{
	float3 col =  postProcTexture.Sample(linearSampler,input.tex);
	col -= postProcTexture.Sample(linearSampler,input.tex.xy - 0.003)*2.7f;
	col += postProcTexture.Sample(linearSampler,input.tex.xy + 0.003)*2.7f;
	return  (col.x+col.y+col.z)/3.0;


}
technique11 basic
{
	pass basicGrayEdge
	{
		SetVertexShader ( 
			CompileShader( vs_5_0, vsQuad() ) );
		SetGeometryShader ( NULL );
		SetRasterizerState( defaultRasterizer );
		SetPixelShader( 
			CompileShader( ps_5_0, psGrayEdge() ) );
		SetDepthStencilState( noDepthTestCompositor, 0 );
		SetBlendState( defaultBlender, 
			float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF  );
	}
	pass basicBox
	{
		SetVertexShader ( CompileShader(
			vs_5_0, vsTrafo() ) );
		SetGeometryShader ( NULL );
		SetRasterizerState( defaultRasterizer );
		SetPixelShader( CompileShader(
			ps_5_0, psBasicBox() ) );
		SetDepthStencilState( defaultCompositor, 0 );
		SetBlendState( defaultBlender, 
			float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF  ); 
	}
	pass basicTextured
	{
		SetVertexShader ( CompileShader(
			vs_5_0, vsTrafoTextured() ) );
		SetGeometryShader ( NULL );
		SetRasterizerState( defaultRasterizer );
		SetPixelShader( CompileShader(
			ps_5_0, psBasicTextured() ) );
		SetDepthStencilState( defaultCompositor, 0 );
		SetBlendState( alphaBlender, 
			float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF  ); 
	}
	pass basic
	{
		SetVertexShader ( CompileShader(
			vs_5_0, vsTrafo() ) );
		SetGeometryShader ( NULL );
		SetRasterizerState( defaultRasterizer );
		SetPixelShader( CompileShader(
			ps_5_0, psBasic() ) );
		SetDepthStencilState( defaultCompositor, 0 );
		SetBlendState( defaultBlender, 
			float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF  ); 
	}

	pass basicEnvMapped
	{
		SetVertexShader ( CompileShader(
			vs_5_0, vsTrafo() ) );
		SetGeometryShader ( NULL );
		SetRasterizerState( defaultRasterizer );
		SetPixelShader( CompileShader(
			ps_5_0, psBasicEnvMapped() ) );
		SetDepthStencilState( defaultCompositor, 0 );
		SetBlendState( defaultBlender, 
			float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF  ); 
	}
	pass basicInstancedEnvMapped
	{
		SetVertexShader ( CompileShader(
			vs_5_0, vsTrafoInstanced() ) );
		SetGeometryShader ( NULL );
		SetRasterizerState( defaultRasterizer );
		SetPixelShader( CompileShader(
			ps_5_0, psBasicInstancedEnvMapped() ) );
		SetDepthStencilState( defaultCompositor, 0 );
		SetBlendState( defaultBlender, 
			float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF  ); 
	}
	pass basicInstanced
	{
		SetVertexShader ( CompileShader(
			vs_5_0, vsTrafoInstanced() ) );
		SetGeometryShader ( NULL );
		SetRasterizerState( defaultRasterizer );
		SetPixelShader( CompileShader(
			ps_5_0, psBasicInstanced() ) );
		SetDepthStencilState( defaultCompositor, 0 );
		SetBlendState( defaultBlender, 
			float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF  ); 
	}
	pass background
	{
		SetVertexShader ( CompileShader( vs_5_0, 
			vsQuad() ) );
		SetGeometryShader ( NULL );
		SetRasterizerState( defaultRasterizer );
		SetPixelShader( CompileShader( ps_5_0, psBackground() ) );
		SetDepthStencilState( defaultCompositor, 0 );
		SetBlendState( defaultBlender, 
			float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF  ); 
	}

}


technique11 gray {
	pass gray {
		SetVertexShader ( 
			CompileShader( vs_5_0, vsQuad() ) );
		SetGeometryShader ( NULL );
		SetRasterizerState( defaultRasterizer );
		SetPixelShader( 
			CompileShader( ps_5_0, psGray() ) );
		SetDepthStencilState( noDepthTestCompositor, 0 );
		SetBlendState( alphaBlender,
			float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF  );
	}
}
technique11 wave {
	pass wave {
		SetVertexShader ( 
			CompileShader( vs_5_0, vsQuad() ) );
		SetGeometryShader ( NULL );
		SetRasterizerState( defaultRasterizer );
		SetPixelShader( 
			CompileShader( ps_5_0, psWave() ) );
		SetDepthStencilState( noDepthTestCompositor, 0 );
		SetBlendState( defaultBlender, 
			float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF  );
	}
}
technique11 blur {
	pass blur {
		SetVertexShader ( 
			CompileShader( vs_5_0, vsQuad() ) );
		SetGeometryShader ( NULL );
		SetRasterizerState( defaultRasterizer );
		SetPixelShader( 
			CompileShader( ps_5_0, psBlur() ) );
		SetDepthStencilState( noDepthTestCompositor, 0 );
		SetBlendState( defaultBlender, 
			float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF  );
	}
}