varying vec2 texcoord;
uniform float power;
uniform vec2 noiseoffset;
uniform sampler2D tex0;
uniform sampler2D noisetex;

void main(void)
{
	vec4 texel = texture2D(tex0, texcoord);	

	vec2 uv = vec2(mod(texcoord.x+noiseoffset.x, 1.0), mod(texcoord.y+noiseoffset.y, 1.0));

	vec4 noisetexel = texture2D(noisetex, uv) * power;
	
	gl_FragColor = texel + noisetexel; 
}