#extension GL_EXT_gpu_shader4: require
uniform float Side;
varying vec3 out_vpos;
vec3 mod289(vec3 x)
{
return x - floor(x * (1.0 / 289.0)) * 289.0;
}
vec4 mod289(vec4 x)
{
return x - floor(x * (1.0 / 289.0)) * 289.0;
}
vec4 permute(vec4 x)
{
return mod289(((x*34.0)+1.0)*x);
}
vec4 taylorInvSqrt(vec4 r)
{
return 1.79284291400159 - 0.85373472095314 * r;
}
float snoise(vec3 v)
{
const vec2  C = vec2(1.0/6.0, 1.0/3.0) ;
const vec4  D = vec4(0.0, 0.5, 1.0, 2.0);
vec3 i  = floor(v + dot(v, C.yyy) );
vec3 x0 =   v - i + dot(i, C.xxx) ;
vec3 g = step(x0.yzx, x0.xyz);
vec3 l = 1.0 - g;
vec3 i1 = min( g.xyz, l.zxy );
vec3 i2 = max( g.xyz, l.zxy );
vec3 x1 = x0 - i1 + C.xxx;
vec3 x2 = x0 - i2 + C.yyy;
vec3 x3 = x0 - D.yyy;
i = mod289(i);
vec4 p = permute( permute( permute(
i.z + vec4(0.0, i1.z, i2.z, 1.0 ))
+ i.y + vec4(0.0, i1.y, i2.y, 1.0 ))
+ i.x + vec4(0.0, i1.x, i2.x, 1.0 ));
float n_ = 0.142857142857;
vec3  ns = n_ * D.wyz - D.xzx;
vec4 j = p - 49.0 * floor(p * ns.z * ns.z);
vec4 x_ = floor(j * ns.z);
vec4 y_ = floor(j - 7.0 * x_ );
vec4 x = x_ *ns.x + ns.yyyy;
vec4 y = y_ *ns.x + ns.yyyy;
vec4 h = 1.0 - abs(x) - abs(y);
vec4 b0 = vec4( x.xy, y.xy );
vec4 b1 = vec4( x.zw, y.zw );
vec4 s0 = floor(b0)*2.0 + 1.0;
vec4 s1 = floor(b1)*2.0 + 1.0;
vec4 sh = -step(h, vec4(0.0));
vec4 a0 = b0.xzyw + s0.xzyw*sh.xxyy ;
vec4 a1 = b1.xzyw + s1.xzyw*sh.zzww ;
vec3 p0 = vec3(a0.xy,h.x);
vec3 p1 = vec3(a0.zw,h.y);
vec3 p2 = vec3(a1.xy,h.z);
vec3 p3 = vec3(a1.zw,h.w);
vec4 norm = taylorInvSqrt(vec4(dot(p0,p0), dot(p1,p1), dot(p2, p2), dot(p3,p3)));
p0 *= norm.x;
p1 *= norm.y;
p2 *= norm.z;
p3 *= norm.w;
vec4 m = max(0.6 - vec4(dot(x0,x0), dot(x1,x1), dot(x2,x2), dot(x3,x3)), 0.0);
m = m * m;
return 42.0 * dot( m*m, vec4( dot(p0,x0), dot(p1,x1),
dot(p2,x2), dot(p3,x3) ) ) + 0.0;
}
void main()
{
vec3 UnitCube = gl_Vertex.xzy;
float X = UnitCube.x * 2. - 1.;
float CliffDensity = 0.5;
float CliffDist    = 3.;
float CliffXSize   = 0.016;
UnitCube.x = (X*Side > 0.) ?  pow(abs(X), CliffDensity) * CliffXSize    : -pow(abs(X), 2.);
UnitCube.y = (X*Side > 0.) ? -pow(pow(abs(X), CliffDensity), CliffDist) : 0.0;
UnitCube.x *= Side;
out_vpos = UnitCube * vec3(10000,
2400,
24000);
float DistFactor = max(1. - abs(out_vpos.x) / 4000., 0.)*0.;
float mountain_factor = max(1. - (length((out_vpos.xz - vec2(0., 540.)) * vec2(0.4, 1.0))  / 2500.), 0.);
float Amp  = 200.;
float Freq = 0.0005;
vec3 VPosOfs = vec3(0);
for (int i = 1; i < 10; i++)
{
VPosOfs += vec3(snoise(out_vpos * Freq + 2.3) * 0.6,
snoise(out_vpos * Freq + 3.4) * (0.6 + DistFactor * 0.01),
snoise(out_vpos * Freq + 6.4) * (0.6 + DistFactor * 0.01)) * Amp;
Freq *= 2.;
Amp  /= 2.;
}
VPosOfs *= 1. + abs(VPosOfs.z)*0.01;
VPosOfs.y += (2400. + out_vpos.y*0.) * 2. * pow(mountain_factor, 2.);
Amp  = 2000.;
Freq = 0.0005;
for (int i = 1; i < 10; i++)
{
VPosOfs.y += snoise(out_vpos * Freq + 3.4) * (1. - pow(DistFactor, 2.)) * pow(mountain_factor, 2.) * Amp;
Freq *= 2.;
Amp  /= 2.;
}
out_vpos += VPosOfs;
}