uniform sampler2D in_VPos;
uniform sampler2D in_Source;
uniform sampler2D in_FogMask;
varying vec2 uv;
uniform vec3 FogColor;
uniform float Density;
void main(void)
{
vec3 Pos = texture2D(in_VPos, uv).rgb;
if (Pos == vec3(0))
{
gl_FragColor = vec4(FogColor.rgb, 1.);
return;
}
vec3 SrcColor = texture2D(in_Source, uv).rgb;
vec4 FogPoint = texture2D(in_FogMask, uv);
float EyeToPos = length(Pos);
float EyeToFog = length(FogPoint.xyz);
if ((EyeToPos < EyeToFog) || (EyeToFog == 0.))
EyeToFog = EyeToPos;
float FogFactor = min(EyeToFog * Density + (EyeToPos - EyeToFog) * FogPoint.a, 1.);
FogFactor = pow(FogFactor, 2.);
gl_FragColor = vec4(mix(SrcColor, FogColor, FogFactor), 1.);
}