/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

public class IntBitfield {
    public static final int UNIT_SIZE = 32;
    private final int[] storage;
    private final long bits;

    public IntBitfield(long l) {
        int n = (int)((l + 7L) / 32L);
        this.storage = new int[n];
        this.bits = (long)n * 32L;
    }

    private final void check(long l) {
        if (0L > l || l >= this.bits) {
            throw new ArrayIndexOutOfBoundsException("Bitnum should be within [0.." + (this.bits - 1L) + "], but is " + l);
        }
    }

    public final long capacity() {
        return this.bits;
    }

    public final boolean get(long l) {
        this.check(l);
        int n = (int)(l / 32L);
        int n2 = (int)(l - (long)(n * 32));
        return 0 != (this.storage[n] & 1 << n2);
    }

    public final boolean put(long l, boolean bl) {
        boolean bl2;
        this.check(l);
        int n = (int)(l / 32L);
        int n2 = (int)(l - (long)(n * 32));
        int n3 = 1 << n2;
        boolean bl3 = bl2 = 0 != (this.storage[n] & n3);
        if (bl2 != bl) {
            if (bl) {
                int n4 = n;
                this.storage[n4] = this.storage[n4] | n3;
            } else {
                int n5 = n;
                this.storage[n5] = this.storage[n5] & ~n3;
            }
        }
        return bl2;
    }
}

