/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.AudioMetaData;
import ddf.minim.Minim;
import ddf.minim.Playable;
import ddf.minim.UGen;
import ddf.minim.spi.AudioRecordingStream;
import java.util.Arrays;

public class FilePlayer
extends UGen
implements Playable {
    private AudioRecordingStream mFileStream;

    public FilePlayer(AudioRecordingStream audioRecordingStream) {
        this.mFileStream = audioRecordingStream;
        this.mFileStream.play();
    }

    public AudioRecordingStream getStream() {
        return this.mFileStream;
    }

    @Override
    public void play() {
        this.mFileStream.play();
    }

    @Override
    public void play(int n) {
        this.cue(n);
        this.play();
    }

    @Override
    public void pause() {
        this.mFileStream.pause();
    }

    @Override
    public void rewind() {
        this.cue(0);
    }

    @Override
    public void loop() {
        this.mFileStream.loop(-1);
    }

    @Override
    public void loop(int n) {
        this.mFileStream.loop(n);
    }

    @Override
    public int loopCount() {
        return this.mFileStream.getLoopCount();
    }

    @Override
    public int length() {
        return this.mFileStream.getMillisecondLength();
    }

    @Override
    public int position() {
        return this.mFileStream.getMillisecondPosition();
    }

    @Override
    public void cue(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > this.length()) {
            n = this.length();
        }
        this.mFileStream.setMillisecondPosition(n);
    }

    @Override
    public void skip(int n) {
        int n2 = this.position() + n;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > this.length()) {
            n2 = this.length();
        }
        Minim.debug("AudioPlayer.skip: skipping " + n + " milliseconds, new position is " + n2);
        this.mFileStream.setMillisecondPosition(n2);
    }

    @Override
    public boolean isLooping() {
        return this.mFileStream.getLoopCount() != 0;
    }

    @Override
    public boolean isPlaying() {
        return this.mFileStream.isPlaying();
    }

    @Override
    public AudioMetaData getMetaData() {
        return this.mFileStream.getMetaData();
    }

    @Override
    public void setLoopPoints(int n, int n2) {
        this.mFileStream.setLoopPoints(n, n2);
    }

    public void close() {
        this.mFileStream.close();
    }

    @Override
    protected void uGenerate(float[] fArray) {
        if (this.mFileStream.isPlaying()) {
            float[] fArray2 = this.mFileStream.read();
            if (fArray2.length == 1) {
                Arrays.fill(fArray, fArray2[0]);
            }
            if (fArray2.length <= fArray.length) {
                System.arraycopy(fArray2, 0, fArray, 0, fArray2.length);
            } else if (fArray.length == 1 && fArray2.length == 2) {
                fArray[0] = (fArray2[0] + fArray2[1]) / 2.0f;
            }
        } else {
            Arrays.fill(fArray, 0.0f);
        }
    }
}

