import ddf.minim.spi.*;
import ddf.minim.signals.*;
import ddf.minim.*;
import ddf.minim.analysis.*;
import ddf.minim.ugens.*;
import ddf.minim.effects.*;

int window_width=1280, window_height=720;
BallEngine be;

PGraphics buf;
PGraphics gradient_bg;
PGraphics credits;

float camera_z=0;
color[] colors;
boolean audio_on=false;
float credits_zoom=0.0f;
// grey 153,153,153
// pink 234,97,150
// blue 0, 160, 227
// white 240, 241, 235
// brown 254, 213, 109

Minim minim;
AudioPlayer player;
AudioInput input;

int audio_jitter=20;

String[] greets;
int greet_index=8;

void setup() {
  minim = new Minim(this);
  player = minim.loadFile("greensynth12.mp3");
  
  size(window_width, window_height, P3D);
  randomSeed(123456789);
  colors = new color[4];
  colors[0] = color(234,97,150);
  colors[1] = color(0,160,227);
  colors[2] = color(240,241,235);
  colors[3] = color(254,213,109);
  
  greets = new String[9];
  greets[0] = "TEKOTUOTANTO";
  greets[1] = "on unohdettu profeetta";
  greets[2] = "GZRRPLOX";
  greets[3] = "on unohdettu profeetta";
  greets[4] = "RAGE MANIFESTO";
  greets[5] = "on unohdettu profeetta";
  greets[6] = "HEAR";
  greets[7] = "on unohdettu profeetta";
  greets[8] = "";
  
  be = new BallEngine(30);
  buf = createGraphics(window_width+audio_jitter, window_height+audio_jitter, P3D);  
  gradient_bg = createGraphics(window_width, window_height);  
  createGreadientBackground(gradient_bg);
  
  credits = createGraphics(window_width, window_height);  
  createCredits(credits);
}


void draw() {
  if (millis() > 4500 &&  millis() < 240000 ) {
    if (!audio_on && millis() > 5000) {
      audio_on=true;
      player.play();
    }
    
    background(153);
   
    camera_z += 0.000002f * millis();
    buf.camera(1.0, camera_z, 1.0, 0.0, 0.0, 0.0, 
         0.0, 1.0, 0.0);
    be.draw(buf,player.left.get(512));
    
    image(gradient_bg,0,0);
    image(buf,player.left.get(0)*-audio_jitter,player.right.get(0)*-audio_jitter);
    
    if (millis() > 30000) {
      if (millis() < 50000) {
        credits_zoom += millis() * 0.0005f;
        image(credits,-credits_zoom,-credits_zoom, credits.width+credits_zoom*2, credits.height+credits_zoom*2); 
      }
    } else {
     image(credits,0,0); 
    }
    
    drawGreets();
    
  } else {
    background(153);
    image(gradient_bg,0,0);
  }
}

void createGreadientBackground(PGraphics pg) {
  int m_x=pg.width / 2;
  int m_y=pg.height / 2;
  
  pg.loadPixels();
  int alpha;

  for (int y=0; y<pg.height;y++) { 
    for (int x=0; x<pg.width;x++) {
      alpha = int(sqrt(pow(x-m_x, 2.0) + pow(y-m_y, 2.0)) * 0.2f);
      pg.pixels[y*pg.width + x] = color(0,0,0,alpha);
    }
  } 
  pg.updatePixels();
}


void drawGreets() {
 
if (millis() > 70000 && millis() < 88000) {
 
  
  if (millis() > 70000 && millis() < 72000) {
  greet_index=0;
  }
  if (millis() > 72000 && millis() < 73000) {
  greet_index=1;
  }
    
  if (millis() > 75000 && millis() < 77000) {
  greet_index=2;
  }
  if (millis() > 77000 && millis() < 78000) {
  greet_index=3;
  } 
  
  if (millis() > 80000 && millis() < 82000) {
  greet_index=4;
  } 
  if (millis() > 82000 && millis() < 83000) {
  greet_index=5;
  } 
  
  if (millis() > 85000 && millis() < 87000) {
  greet_index=6;
  } 
  if (millis() > 87000 && millis() < 88000) {
  greet_index=7;
  } 
  

  int text_size=64;
  if (greet_index % 2 == 0) {
    fill(234,97,150);
  } else {
    text_size=48;
    fill(255);
  }
   
  textSize(text_size);
  text(greets[greet_index], 150, height-text_size-30); 
  }
}

void createCredits(PGraphics pg) {
  color w = color(255);
  pg.beginDraw();
  pg.background(0);
  int padding=200;
  pg.fill(w);
  pg.triangle(pg.width/2, padding/2, padding, pg.height-padding, pg.width-padding, pg.height-padding);
  
 
  pg.loadPixels();
  for (int y=0; y<pg.height;y++) { 
    for (int x=0; x<pg.width;x++) {
      pg.pixels[y*pg.width + x] = color(0,0,0,255-red(pg.pixels[y*pg.width + x]));
    }
  } 
  pg.updatePixels();
  
  int text_padding=5;
  int text_size=64;
  pg.textSize(text_size);
  pg.text("Unohdetut Profeetat", padding+100, pg.height-padding+text_size); 
  
  pg.pushMatrix();
  pg.translate(pg.width/2, padding/2);
  pg.rotate(radians(50));
  pg.text("jypa", 150, -50); 
  pg.popMatrix(); 
  
  pg.pushMatrix();
  pg.translate(pg.width/2-text_size-text_padding*2, padding/2);
  pg.rotate(radians(137));
  pg.text("Yangoon Systems", 0, 10); 
  pg.popMatrix();
  
  pg.endDraw();
}

class BallEngine {
  int max_balls;
  Ball[] balls;
  float rotate_single_y=0f;
  float rotate_y=0f;
 
  BallEngine(int max_balls) {
    this.max_balls=max_balls;
    this.balls = new Ball[max_balls];    
    addBalls();
  }
  
  void addBalls() {
    boolean god=false;
    for(int i=0; i<this.max_balls;i++) {
      god = (i == 3);
      balls[i] = new Ball(random(-400,400), random(-400,400), random(-400,400), random(0.00001f, 0.0001f), colors[i%4], god);
    }
  }
  
  void draw(PGraphics buf, float color_intensity) {
     buf.beginDraw();
     buf.background(0,0,0,0);
     buf.noStroke();
     buf.lights();
     buf.lightFalloff(1.0, 0.001, 0.0);
     buf.sphereDetail(50);
     Ball b;
     
     for(int i=0; i<this.max_balls;i++) {
       b = this.balls[i];
       buf.fill(b.c);
       buf.pushMatrix();
       
       b.rotate_y = b.speed * millis();
       b.rotate_x = b.speed * millis();
       float ry=b.rotate_y;
       float rx=b.rotate_x;
       
       buf.rotateY(ry);
       buf.rotateY(rx);
       
       buf.translate(b.x, b.y, b.z);
       buf.sphere(40);
       buf.popMatrix();
     }
     
     buf.endDraw();
  }
}

class Ball {
  int x,y,z;
  float rotate_y, rotate_x;
  float speed;
  color c;
  boolean god;
  
  Ball(float x, float y, float z, float speed, color c, boolean god) {
    this.x=int(x);
    this.y=int(y);
    this.z=int(z);
    this.rotate_y=0;
    this.rotate_x=0;
    this.speed=speed;
    this.c=c;
    this.god=god;
  }
}

void stop()
{
// the AudioPlayer you got from Minim.loadFile()
player.close();
// the AudioInput you got from Minim.getLineIn()
minim.stop();
super.stop();
}
