#version 430

in vec3 fPos;
in vec3 fNor;
in vec3 fCol;
in vec3 fTex;
in vec3 fTan;
in vec3 fBit;

in vec4 fAmb;
in vec4 fDif;
in vec4 fSpc;
in float fShi;

out vec4 mrt[8];

uniform sampler2D texDiff;
uniform sampler2D texNorm;
uniform sampler2D texSpec;

uniform mat4 modelView;

void main()
{
	mrt[0] = vec4( fPos, 1); // pos
	mrt[1] = vec4( normalize( fNor ), 0 ); // vertex normal
	mrt[2] = vec4( texture( texDiff, fTex.xy ).xyz, 1 ); // diffuse map
	mrt[3] = vec4( fTex, 0 ); // texture coordinates

	// tangent, bitangent and normalmap vectors
	mrt[4] = vec4( normalize( fTan ), 0 );
	mrt[5] = vec4( normalize( fBit ), 0 );
	// normal map
	mrt[6] = vec4( texture( texNorm, fTex.xy ).xyz, 0 );
	// spec map
	mrt[7] = vec4( texture( texSpec, fTex.xy).r,0,0, 0);
}