#version 330

in vec2 fTex;

out vec4 oCol;

uniform sampler1D sampleDataTexLeft;
uniform sampler1D sampleDataTexRight;
uniform int nrSlices;
uniform int nrSamplesPerSlice;

void main()
{
	// compute texture coordinate for sampler
	int sliceNr = int(floor(fTex.x * nrSlices));
	// which slice are we on?
	float texSliceOffset = sliceNr / float(nrSlices);
	// how many texels is a slice?
	float texWidthLeft = fTex.y * float(nrSamplesPerSlice)/float(nrSamplesPerSlice*nrSlices);
	float texWidthRight = (1.0 - fTex.y) * float(nrSamplesPerSlice)/float(nrSamplesPerSlice*nrSlices);

	float col = 0.0;
	if (sliceNr % 2 == 0) {
		col = abs( texture(sampleDataTexLeft, texSliceOffset+texWidthLeft).r);
	} else {
		col = abs( texture(sampleDataTexRight, texSliceOffset+texWidthRight).r);
	}

	float alpha = clamp(1 - length((fTex - 0.5) * 2), 0.0, 1.0);
	oCol = vec4(col, col, col, alpha);
}