#version 430

in vec2 fTex;

out vec4 oCol;

// G-buffer textures
uniform sampler2D texPos;
uniform sampler2D texNor;
uniform sampler2D texCol;
uniform sampler2D texTex;
uniform sampler2D texTan;
uniform sampler2D texBit;
uniform sampler2D texBum;
uniform sampler2D texSpc;
uniform samplerCubeShadow shadowMap;

uniform vec3 lightPos;
uniform vec3 lightAmb;
uniform vec3 lightDif;
uniform vec3 lightSpc;
uniform float blinnTermExponent;
uniform float intensity;
uniform float attenuationExponent;


void main() {

	vec3 pos = texture(texPos, fTex).xyz;
	vec3 nor = normalize(texture(texNor, fTex).xyz);
	vec4 colorMap = texture(texCol, fTex);
	vec4 tex = texture(texTex, fTex);
	vec3 t = normalize(texture(texTan, fTex).xyz);
	vec3 b = normalize(texture(texBit, fTex).xyz);
	
	vec3 unscaledBumpMap = texture(texBum, fTex).xyz;
	vec3 scaledBumpMap = normalize(2.0 * unscaledBumpMap - 1.0);

	float specMap = texture(texSpc, fTex).r;

	//mat3 TBN = mat3(t, b, nor);
	mat3 TBN = mat3(t.x, b.x, nor.x, 
					t.y, b.y, nor.y, 
					t.z, b.z, nor.z);

	vec3 N = scaledBumpMap;

	// position
	vec3 p = pos;

	// light pos
	vec3 lp = lightPos; 


	// Light direction tangent space
	vec3 L = TBN * normalize(lp - p); 

	float cosAngIncidence = dot(N, L);
	cosAngIncidence = clamp(cosAngIncidence, 0.0, 1.0);

	vec3 V = normalize(-pos);
	V = TBN * V;

	vec3 H = normalize(L + V);


	float blinnTerm = dot(N, H);
	blinnTerm = clamp(blinnTerm, 0.0, 1.0);
	cosAngIncidence != 0.0 ? blinnTerm : 0.0;
	blinnTerm = pow(blinnTerm , blinnTermExponent);
	
	vec3 spec_color = vec3(1);
	float distance = length( lightPos.xyz - pos.xyz );
	float attenuation = 1.0 / (1.0 + pow( distance, attenuationExponent));

	oCol = vec4(colorMap.xyz * attenuation * cosAngIncidence,1); // diffuse
	oCol += vec4(specMap * spec_color * attenuation * blinnTerm,0); // specular
	
	vec4 worldSpaceFragPos =	vec4(pos,1);
	vec4 worldSpaceLightPos =	vec4(lp, 1);
	vec4 faceSelect = worldSpaceFragPos - worldSpaceLightPos;
	vec3 absFaceSelect = abs(faceSelect.xyz);
	float zComp = max(absFaceSelect.x, max(absFaceSelect.y, absFaceSelect.z));
	float depthCompare = ( (70.0 + 0.1) / (70.0 - 0.1) - (2.0 * 70.0 * 0.1) / (70.0 - 0.1) / zComp + 1.0 ) * 0.5;
	float shadow = texture( shadowMap, vec4(faceSelect.xyz, depthCompare - 0.0001 ) );
	oCol.xyz *= shadow;	
	oCol.xyz *= intensity;
	oCol.a = 1.0;
}
