#version 330

in vec2 fTex;

out vec4 oCol;

uniform sampler2D texPos;
uniform sampler2D texNor;
uniform sampler2D texCol;

uniform sampler2D texIkeda;
uniform vec3 projectorPos;               

uniform mat4 T;

const vec3 lightPos = vec3(0.0, 0.0, 2.0);
const vec4 ambient = vec4(0.15, 0.15, 0.15, 1.0);
const vec4 diffuse = vec4(0.2, 0.2, 0.2, 1.0);
const vec4 specular = vec4(0.75, 0.75, 0.75, 1.0);
const float shininess = 5.0;

void main()
{	
	vec3 pos = texture(texPos, fTex).rgb;
	vec3 nor = texture(texNor, fTex).rgb;
	
	vec3 L = normalize(lightPos - pos);
	vec3 E = normalize(-pos);
	vec3 R = normalize(-reflect(L, nor));

	vec4 amb = ambient;
	vec4 diff = diffuse * max(dot(nor,L), 0.0);
	diff = clamp(diff, 0.0, 1.0);

	vec4 spec = specular * vec4(pow(max(dot(R,E), 0.0), shininess));
	spec = clamp(spec, 0.0, 1.0);

	oCol = vec4(texture(texCol, fTex).rgb, 1.0) * ( amb + diff + spec );
	//oCol = ( amb + diff + spec );
}