// blur lifted from mfx 
#version 330

in vec2 fTex;
in vec2 pVec;
out vec4 oCol;

uniform float aspectRatio;
uniform sampler2D sTexture;
uniform sampler2D sNoise;
uniform float blink;
uniform vec2 noiseSamplerOffset;


const vec2 pixels[13] = vec2[13](vec2( -6, -6 ),vec2( -5, -5 ),vec2( -4, -4 ),vec2( -3, -3 ),vec2( -2, -2 ),vec2( -1, -1 ),vec2(  0, 0 ),vec2(  1, 1 ),vec2(  2, 2 ),vec2(  3, 3 ),vec2(  4, 4 ),vec2(  5, 5 ),vec2(  6, 6 ));
const vec3 noiseFactor = vec3(0.815);
const float weights[13] =
float[13](
    0.002216,
    0.008764,
    0.026995,
    0.064759,
    0.120985,
    0.176033,
    0.199471,
    0.176033,
    0.120985,
    0.064759,
    0.026995,
    0.008764,
    0.002216
);


void main(void)
{

	// vignette
	float radius = 0.4 * (pVec.x * pVec.x) / (-0.8 * -0.8) + aspectRatio * (pVec.y * pVec.y) / (0.8 * 0.8);
	radius = smoothstep(0.0, 1.0, blink - radius);


	vec3 col = texture(sTexture, fTex).rgb;
	vec3 n = vec3(texture(sNoise, fTex + noiseSamplerOffset).r);

	//for (int i = 0; i < 13; ++i) {
		//col += texture(sTexture, fTex + pixels[i] * 0.00025).rgb * weights[i];
	//}

	vec3 rgb = col * vec3(radius);
	oCol = vec4(rgb, 1.0);

	//vec3 col = vec3(0.0);
	//vec3 lol = texture(sTexture, fTex).rgb;
	//vec3 n = vec3(texture(sNoise, fTex + noiseSamplerOffset).r);
//
	//for (int i = 0; i < 13; ++i) {
		//col += texture(sTexture, fTex + pixels[i] * 0.00025).rgb * weights[i];
	//}
//
	//vec3 rgb = col * vec3(radius) * (noiseFactor * lol  + vec3((1.0 - noiseFactor) * n));
	//oCol = vec4(rgb, 1.0);
}