#version 430

in vec2 fTex;

out vec4 oCol;

uniform sampler2D texFbo1; // regular
uniform sampler2D texFbo2; // brightpass
uniform sampler2D texNoise;
uniform vec2 noiseOffset;
uniform float time;


void main(void)
{
	// CA
	float offsetScale = abs(sin(time)) * -0.165 - 0.005;
	vec2 offset = (fTex - 0.5) * pow(offsetScale,3.0);
	vec2 roff = clamp(vec2(fTex + offset), 0.0, 1.0);
	vec2 boff = clamp(vec2(fTex - offset), 0.0, 1.0);
	float r = texture(texFbo1, roff).r + texture(texFbo2, roff).r;
	float g = texture(texFbo1, fTex ).g + texture(texFbo2, fTex).g;
	float b = texture(texFbo1, boff).b + texture(texFbo2, boff).b;
	oCol = vec4(r,g,b,1.0);
	
	// noise 
	vec3 noise = vec3( texture(texNoise, fTex + noiseOffset).r );
	float lum = r*0.299 + g*0.587 + b*0.114;
	
	oCol += vec4(lum * noise * 0.5, 0);
	oCol.a = 1.0;
}