#version 430

// Triangle strip vertex ordering
//
//			2---3
// 			| \ |
// 			|  \| 
// 			0---1
//

layout(points, invocations = 1) in;
layout(triangle_strip, max_vertices = 4) out;


out VertexData {
	vec2 uv;
} Out;



uniform float aspectRatio;
//uniform float radius;
//uniform float amplitude;

const vec2 signs[4] = vec2[4]( 
	ivec2(-1,-1), ivec2(1, -1), ivec2(-1, 1), ivec2(1, 1)
	);

const vec2 uvs[4] = vec2[4]( 
	vec2(0,1), vec2(1,1), vec2(0,0), vec2(1,0)
	);


void main(void)
{
	float radius = 1.0;
	//vec4 aspectRatio = vec4(666.0 / 313.0, 1, 1, 1);

	for (int i = 0; i < 4; ++i) {
		vec4 pos = gl_in[0].gl_Position 
			+ vec4(radius, radius, 0, 0) * vec4(signs[i], 1, 1)
			* aspectRatio;
		gl_Position = pos;
		Out.uv		= uvs[i];

		EmitVertex();
	}
	EndPrimitive();
}