#version 430

layout(triangles, invocations = 6) in;
layout(triangle_strip, max_vertices = 3) out;


in gl_PerVertex
{
    vec4 gl_Position;
} gl_in[];

uniform mat4 VPmatrices[6];


void main(void) 
{
		for (int vertex = 0; vertex < gl_in.length(); vertex++) {
			gl_Layer = gl_InvocationID;
			gl_Position = VPmatrices[gl_InvocationID] * gl_in[vertex].gl_Position;			
			EmitVertex();
		}
		EndPrimitive();	
}
