// line #1 has to be separate. version directive MUST come first.
version #330

#define TYPE_FLOAT					float
#define TYPE_VEC2					vec2
#define TYPE_VEC3					vec3
#define TYPE_VEC4					vec4 


// generated defines
// trafo requires a uniform mat4 matrix.
#define HAS_TRAFO 
// these must be inserted into the shader code based on the layout of GLvertex.
#define ATTRIB1_TYPE				TYPE_VEC3
#define ATTRIB2_TYPE				TYPE_VEC3
#define ATTRIB3_TYPE				TYPE_VEC4
#define ATTRIB4_TYPE				TYPE_VEC3

// sanity check
#ifndef NUM_VERTEX_ATTRIBS
#error
#endif

#if NUM_VERTEX_ATTRIBS <= 1
#ifndef ATTRIB1_TYPE
#error
#endif
layout(position = 1) ATTRIB1_TYPE a
#endif

#if NUM_VERTEX_ATTRIBS <= 2
#ifndef ATTRIB2_TYPE
#error
#endif
layout(position = 2) ATTRIB2_TYPE b
#endif

#if NUM_VERTEX_ATTRIBS <= 3
#ifndef ATTRIB3_TYPE
#error
#endif
layout(position = 3) ATTRIB3_TYPE c
#endif

#if NUM_VERTEX_ATTRIBS <= 4
#ifndef ATTRIB4_TYPE
#error
#endif
layout(position = 4) ATTRIB4_TYPE d
#endif

#if NUM_VERTEX_ATTRIBS <= 5
#ifndef ATTRIB5_TYPE
#error
#endif
layout(position = 5) ATTRIB5_TYPE e
#endif

#if NUM_VERTEX_ATTRIBS <= 6
#ifndef ATTRIB6_TYPE
#error
#endif
layout(position = 6) ATTRIB6_TYPE f
#endif

#if NUM_VERTEX_ATTRIBS <= 7
#ifndef ATTRIB7_TYPE
#error
#endif
layout(position = 7) ATTRIB7_TYPE g
#endif

#if NUM_VERTEX_ATTRIBS <= 8
#ifndef ATTRIB8_TYPE
#error
#endif
layout(position = 8) ATTRIB8_TYPE g
#endif









#ifdef HAS_TRAFO
uniform mat4 trafo;
#endif

void main()
{
#ifdef HAS_TRAFO
	gl_Position = trafo * a;
#else
	gl_Position = a;
#endif
}



// # attributes
