/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.configuration;

import com.google.inject.Injector;
import javax.inject.Inject;
import tazadum.engine.configuration.ConfigurationManager;
import tazadum.engine.configuration.InputManager;
import tazadum.engine.configuration.ParameterManager;
import tazadum.engine.configuration.TimelineManager;
import tazadum.engine.time.TimeManager;

public class ConfigurationManagerImpl
implements ConfigurationManager {
    private final TimeManager timeManager;
    private final TimelineManager timelineManager;
    private final ParameterManager parameterManager;

    @Inject
    public ConfigurationManagerImpl(TimeManager timeManager, TimelineManager timelineManager, ParameterManager parameterManager, InputManager inputManager) {
        this.timeManager = timeManager;
        this.timelineManager = timelineManager;
        this.parameterManager = parameterManager;
    }

    @Override
    public void load(Injector injector, String string, float f) {
        int n = string.lastIndexOf(47);
        if (n < 0) {
            this.parameterManager.load("parameters/*.json");
        } else {
            String string2 = string.substring(0, n);
            this.parameterManager.load(string2 + "/parameters/*.json");
        }
        this.timelineManager.load(injector, string, f);
    }

    @Override
    public TimeManager getTimeManager() {
        return this.timeManager;
    }

    @Override
    public TimelineManager getTimelineManager() {
        return this.timelineManager;
    }

    @Override
    public ParameterManager getParameterManager() {
        return this.parameterManager;
    }
}

