/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.configuration;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.inject.Inject;
import javax.swing.JFrame;
import tazadum.engine.configuration.InputManager;
import tazadum.engine.time.TimeManager;
import tazadum.engine.ui.event.PlayPauseActionEvent;
import tazadum.engine.ui.event.PlayPauseEvent;
import tazadum.engine.util.event.EventBus;

public class InputManagerImpl
implements InputManager {
    private final KeyListener keyListener = new KeyListener();
    private final EventBus eventBus;
    private final TimeManager timeManager;

    @Inject
    public InputManagerImpl(EventBus eventBus, TimeManager timeManager) {
        this.eventBus = eventBus;
        this.timeManager = timeManager;
    }

    @Override
    public void connect(JFrame ... jFrameArray) {
        for (JFrame jFrame : jFrameArray) {
            jFrame.addKeyListener(this.keyListener);
        }
    }

    private class KeyListener
    extends KeyAdapter {
        private static final float SMALL_STEP = 2.0f;
        private static final float BIG_STEP = 30.0f;

        private KeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            float f = InputManagerImpl.this.timeManager.getTime();
            switch (keyEvent.getKeyCode()) {
                case 37: {
                    InputManagerImpl.this.timeManager.setTime(Math.max(0.0f, f - 2.0f));
                    break;
                }
                case 39: {
                    InputManagerImpl.this.timeManager.setTime(f + 2.0f);
                    break;
                }
                case 38: {
                    InputManagerImpl.this.timeManager.setTime(Math.max(0.0f, f + 30.0f));
                    break;
                }
                case 40: {
                    InputManagerImpl.this.timeManager.setTime(Math.max(0.0f, f - 30.0f));
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            switch (keyEvent.getKeyChar()) {
                case ' ': {
                    InputManagerImpl.this.eventBus.fireEvent(new PlayPauseActionEvent(InputManagerImpl.this.timeManager.isPaused() ? PlayPauseEvent.Action.Play : PlayPauseEvent.Action.Pause));
                }
            }
        }
    }
}

