/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.math;

import java.util.logging.Logger;
import tazadum.engine.math.Vector3f;

public class Plane {
    private static final Logger logger = Logger.getLogger(Plane.class.getName());
    protected Vector3f normal;
    protected float constant;

    public Plane() {
        this.normal = new Vector3f();
    }

    public Plane(Vector3f vector3f, float f) {
        if (vector3f == null) {
            logger.warning("Normal was null, created default normal.");
            vector3f = new Vector3f();
        }
        this.normal = vector3f;
        this.constant = f;
    }

    public void setNormal(Vector3f vector3f) {
        if (vector3f == null) {
            logger.warning("Normal was null, created default normal.");
            vector3f = new Vector3f();
        }
        this.normal.set(vector3f);
    }

    public void setNormal(float f, float f2, float f3) {
        if (this.normal == null) {
            logger.warning("Normal was null, created default normal.");
            this.normal = new Vector3f();
        }
        this.normal.set(f, f2, f3);
    }

    public Vector3f getNormal() {
        return this.normal;
    }

    public void setConstant(float f) {
        this.constant = f;
    }

    public float getConstant() {
        return this.constant;
    }

    public Vector3f getClosestPoint(Vector3f vector3f, Vector3f vector3f2) {
        float f = (this.constant - this.normal.dot(vector3f)) / this.normal.dot(this.normal);
        return vector3f2.set(this.normal).multLocal(f).addLocal(vector3f);
    }

    public Vector3f getClosestPoint(Vector3f vector3f) {
        return this.getClosestPoint(vector3f, new Vector3f());
    }

    public Vector3f reflect(Vector3f vector3f, Vector3f vector3f2) {
        if (vector3f2 == null) {
            vector3f2 = new Vector3f();
        }
        float f = this.pseudoDistance(vector3f);
        vector3f2.set(this.normal).negateLocal().multLocal(f * 2.0f);
        vector3f2.addLocal(vector3f);
        return vector3f2;
    }

    public float pseudoDistance(Vector3f vector3f) {
        return this.normal.dot(vector3f) - this.constant;
    }

    public Side whichSide(Vector3f vector3f) {
        float f = this.pseudoDistance(vector3f);
        if (f < 0.0f) {
            return Side.Negative;
        }
        if (f > 0.0f) {
            return Side.Positive;
        }
        return Side.None;
    }

    public boolean isOnPlane(Vector3f vector3f) {
        float f = this.pseudoDistance(vector3f);
        return f < 1.1920929E-7f && f > -1.1920929E-7f;
    }

    public void setOriginNormal(Vector3f vector3f, Vector3f vector3f2) {
        this.normal.set(vector3f2);
        this.constant = vector3f2.x * vector3f.x + vector3f2.y * vector3f.y + vector3f2.z * vector3f.z;
    }

    public void setPlanePoints(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        this.normal.set(vector3f2).subtractLocal(vector3f);
        this.normal.crossLocal(vector3f3.x - vector3f.x, vector3f3.y - vector3f.y, vector3f3.z - vector3f.z).normalizeLocal();
        this.constant = this.normal.dot(vector3f);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [Normal: " + this.normal + " - Constant: " + this.constant + "]";
    }

    public Plane clone() {
        try {
            Plane plane = (Plane)super.clone();
            plane.normal = this.normal.clone();
            return plane;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }

    public static enum Side {
        None,
        Positive,
        Negative;

    }
}

