/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.math;

import java.util.ArrayList;
import java.util.List;
import tazadum.engine.math.FastMath;
import tazadum.engine.math.Vector3f;

public class Spline {
    private final List<Vector3f> controlPoints = new ArrayList<Vector3f>();
    private boolean cycle = false;
    private List<Float> segmentsLength;
    private float totalLength;
    private List<Vector3f> CRcontrolPoints;
    private float curveTension = 0.5f;
    private SplineType type = SplineType.CatmullRom;

    public Spline() {
    }

    public Spline(SplineType splineType, Vector3f[] vector3fArray, float f, boolean bl) {
        for (int i = 0; i < vector3fArray.length; ++i) {
            Vector3f vector3f = vector3fArray[i];
            this.controlPoints.add(vector3f);
        }
        this.type = splineType;
        this.curveTension = f;
        this.cycle = bl;
        this.computeTotalLentgh();
    }

    public Spline(SplineType splineType, List<Vector3f> list, float f, boolean bl) {
        this.type = splineType;
        this.controlPoints.addAll(list);
        this.curveTension = f;
        this.cycle = bl;
        this.computeTotalLentgh();
    }

    private void initCatmullRomWayPoints(List<Vector3f> list) {
        if (this.CRcontrolPoints == null) {
            this.CRcontrolPoints = new ArrayList<Vector3f>();
        } else {
            this.CRcontrolPoints.clear();
        }
        int n = list.size() - 1;
        if (this.cycle) {
            this.CRcontrolPoints.add(list.get(list.size() - 2));
        } else {
            this.CRcontrolPoints.add(list.get(0).subtract(list.get(1).subtract(list.get(0))));
        }
        for (Vector3f vector3f : list) {
            this.CRcontrolPoints.add(vector3f);
        }
        if (this.cycle) {
            this.CRcontrolPoints.add(list.get(1));
        } else {
            this.CRcontrolPoints.add(list.get(n).add(list.get(n).subtract(list.get(n - 1))));
        }
    }

    public void addControlPoint(Vector3f vector3f) {
        if (this.controlPoints.size() > 2 && this.cycle) {
            this.controlPoints.remove(this.controlPoints.size() - 1);
        }
        this.controlPoints.add(vector3f);
        if (this.controlPoints.size() >= 2 && this.cycle) {
            this.controlPoints.add(this.controlPoints.get(0));
        }
        if (this.controlPoints.size() > 1) {
            this.computeTotalLentgh();
        }
    }

    public void removeControlPoint(Vector3f vector3f) {
        this.controlPoints.remove(vector3f);
        if (this.controlPoints.size() > 1) {
            this.computeTotalLentgh();
        }
    }

    private void computeTotalLentgh() {
        this.totalLength = 0.0f;
        float f = 0.0f;
        if (this.segmentsLength == null) {
            this.segmentsLength = new ArrayList<Float>();
        } else {
            this.segmentsLength.clear();
        }
        if (this.type == SplineType.Linear) {
            if (this.controlPoints.size() > 1) {
                for (int i = 0; i < this.controlPoints.size() - 1; ++i) {
                    f = this.controlPoints.get(i + 1).subtract(this.controlPoints.get(i)).length();
                    this.segmentsLength.add(Float.valueOf(f));
                    this.totalLength += f;
                }
            }
        } else {
            this.initCatmullRomWayPoints(this.controlPoints);
            this.computeCatmulLength();
        }
    }

    private void computeCatmulLength() {
        float f = 0.0f;
        if (this.controlPoints.size() > 1) {
            for (int i = 0; i < this.controlPoints.size() - 1; ++i) {
                f = FastMath.getCatmullRomP1toP2Length(this.CRcontrolPoints.get(i), this.CRcontrolPoints.get(i + 1), this.CRcontrolPoints.get(i + 2), this.CRcontrolPoints.get(i + 3), 0.0f, 1.0f, this.curveTension);
                this.segmentsLength.add(Float.valueOf(f));
                this.totalLength += f;
            }
        }
    }

    public Vector3f interpolate(float f, int n, Vector3f vector3f) {
        if (vector3f == null) {
            vector3f = new Vector3f();
        }
        switch (this.type) {
            case CatmullRom: {
                FastMath.interpolateCatmullRom(f, this.curveTension, this.CRcontrolPoints.get(n), this.CRcontrolPoints.get(n + 1), this.CRcontrolPoints.get(n + 2), this.CRcontrolPoints.get(n + 3), vector3f);
                break;
            }
            case Linear: {
                FastMath.interpolateLinear(f, this.controlPoints.get(n), this.controlPoints.get(n + 1), vector3f);
                break;
            }
            case Bezier: {
                FastMath.interpolateBezier(f, this.controlPoints.get(n), this.controlPoints.get(n + 1), this.controlPoints.get(n + 2), this.controlPoints.get(n + 3), vector3f);
            }
        }
        return vector3f;
    }

    public float getCurveTension() {
        return this.curveTension;
    }

    public void setCurveTension(float f) {
        this.curveTension = f;
        this.computeTotalLentgh();
    }

    public boolean isCycle() {
        return this.cycle;
    }

    public void setCycle(boolean bl) {
        if (this.controlPoints.size() >= 2) {
            if (this.cycle && !bl) {
                this.controlPoints.remove(this.controlPoints.size() - 1);
            }
            if (!this.cycle && bl) {
                this.controlPoints.add(this.controlPoints.get(0));
            }
            this.cycle = bl;
            this.computeTotalLentgh();
        } else {
            this.cycle = bl;
        }
    }

    public float getTotalLength() {
        return this.totalLength;
    }

    public SplineType getType() {
        return this.type;
    }

    public void setType(SplineType splineType) {
        this.type = splineType;
        this.computeTotalLentgh();
    }

    public List<Vector3f> getControlPoints() {
        return this.controlPoints;
    }

    public List<Float> getSegmentsLength() {
        return this.segmentsLength;
    }

    public static enum SplineType {
        Linear,
        CatmullRom,
        Bezier;

    }
}

