/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.math;

import java.util.logging.Logger;
import tazadum.engine.math.FastMath;

public final class Vector4f {
    private static final Logger logger = Logger.getLogger(Vector4f.class.getName());
    public static final Vector4f ZERO = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
    public static final Vector4f NAN = new Vector4f(Float.NaN, Float.NaN, Float.NaN, Float.NaN);
    public static final Vector4f UNIT_X = new Vector4f(1.0f, 0.0f, 0.0f, 0.0f);
    public static final Vector4f UNIT_Y = new Vector4f(0.0f, 1.0f, 0.0f, 0.0f);
    public static final Vector4f UNIT_Z = new Vector4f(0.0f, 0.0f, 1.0f, 0.0f);
    public static final Vector4f UNIT_W = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
    public static final Vector4f UNIT_XYZW = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    public static final Vector4f POSITIVE_INFINITY = new Vector4f(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
    public static final Vector4f NEGATIVE_INFINITY = new Vector4f(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
    public float x;
    public float y;
    public float z;
    public float w;

    public Vector4f() {
        this.w = 0.0f;
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
    }

    public Vector4f(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.w = f4;
    }

    public Vector4f(Vector4f vector4f) {
        this.set(vector4f);
    }

    public Vector4f set(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.w = f4;
        return this;
    }

    public Vector4f set(Vector4f vector4f) {
        this.x = vector4f.x;
        this.y = vector4f.y;
        this.z = vector4f.z;
        this.w = vector4f.w;
        return this;
    }

    public Vector4f add(Vector4f vector4f) {
        if (null == vector4f) {
            logger.warning("Provided vector is null, null returned.");
            return null;
        }
        return new Vector4f(this.x + vector4f.x, this.y + vector4f.y, this.z + vector4f.z, this.w + vector4f.w);
    }

    public Vector4f add(Vector4f vector4f, Vector4f vector4f2) {
        vector4f2.x = this.x + vector4f.x;
        vector4f2.y = this.y + vector4f.y;
        vector4f2.z = this.z + vector4f.z;
        vector4f2.w = this.w + vector4f.w;
        return vector4f2;
    }

    public Vector4f addLocal(Vector4f vector4f) {
        if (null == vector4f) {
            logger.warning("Provided vector is null, null returned.");
            return null;
        }
        this.x += vector4f.x;
        this.y += vector4f.y;
        this.z += vector4f.z;
        this.w += vector4f.w;
        return this;
    }

    public Vector4f add(float f, float f2, float f3, float f4) {
        return new Vector4f(this.x + f, this.y + f2, this.z + f3, this.w + f4);
    }

    public Vector4f addLocal(float f, float f2, float f3, float f4) {
        this.x += f;
        this.y += f2;
        this.z += f3;
        this.w += f4;
        return this;
    }

    public Vector4f scaleAdd(float f, Vector4f vector4f) {
        this.x = this.x * f + vector4f.x;
        this.y = this.y * f + vector4f.y;
        this.z = this.z * f + vector4f.z;
        this.w = this.w * f + vector4f.w;
        return this;
    }

    public Vector4f scaleAdd(float f, Vector4f vector4f, Vector4f vector4f2) {
        this.x = vector4f.x * f + vector4f2.x;
        this.y = vector4f.y * f + vector4f2.y;
        this.z = vector4f.z * f + vector4f2.z;
        this.w = vector4f.w * f + vector4f2.w;
        return this;
    }

    public float dot(Vector4f vector4f) {
        if (null == vector4f) {
            logger.warning("Provided vector is null, 0 returned.");
            return 0.0f;
        }
        return this.x * vector4f.x + this.y * vector4f.y + this.z * vector4f.z + this.w * vector4f.w;
    }

    public Vector4f project(Vector4f vector4f) {
        float f = this.dot(vector4f);
        float f2 = vector4f.lengthSquared();
        return new Vector4f(vector4f).normalizeLocal().multLocal(f / f2);
    }

    public boolean isUnitVector() {
        float f = this.length();
        return 0.99f < f && f < 1.01f;
    }

    public float length() {
        return FastMath.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public float distanceSquared(Vector4f vector4f) {
        double d = this.x - vector4f.x;
        double d2 = this.y - vector4f.y;
        double d3 = this.z - vector4f.z;
        double d4 = this.w - vector4f.w;
        return (float)(d * d + d2 * d2 + d3 * d3 + d4 * d4);
    }

    public float distance(Vector4f vector4f) {
        return FastMath.sqrt(this.distanceSquared(vector4f));
    }

    public Vector4f mult(float f) {
        return new Vector4f(this.x * f, this.y * f, this.z * f, this.w * f);
    }

    public Vector4f mult(float f, Vector4f vector4f) {
        if (null == vector4f) {
            vector4f = new Vector4f();
        }
        vector4f.x = this.x * f;
        vector4f.y = this.y * f;
        vector4f.z = this.z * f;
        vector4f.w = this.w * f;
        return vector4f;
    }

    public Vector4f multLocal(float f) {
        this.x *= f;
        this.y *= f;
        this.z *= f;
        this.w *= f;
        return this;
    }

    public Vector4f multLocal(Vector4f vector4f) {
        if (null == vector4f) {
            logger.warning("Provided vector is null, null returned.");
            return null;
        }
        this.x *= vector4f.x;
        this.y *= vector4f.y;
        this.z *= vector4f.z;
        this.w *= vector4f.w;
        return this;
    }

    public Vector4f multLocal(float f, float f2, float f3, float f4) {
        this.x *= f;
        this.y *= f2;
        this.z *= f3;
        this.w *= f4;
        return this;
    }

    public Vector4f mult(Vector4f vector4f) {
        if (null == vector4f) {
            logger.warning("Provided vector is null, null returned.");
            return null;
        }
        return this.mult(vector4f, null);
    }

    public Vector4f mult(Vector4f vector4f, Vector4f vector4f2) {
        if (null == vector4f) {
            logger.warning("Provided vector is null, null returned.");
            return null;
        }
        if (vector4f2 == null) {
            vector4f2 = new Vector4f();
        }
        return vector4f2.set(this.x * vector4f.x, this.y * vector4f.y, this.z * vector4f.z, this.w * vector4f.w);
    }

    public Vector4f divide(float f) {
        f = 1.0f / f;
        return new Vector4f(this.x * f, this.y * f, this.z * f, this.w * f);
    }

    public Vector4f divideLocal(float f) {
        f = 1.0f / f;
        this.x *= f;
        this.y *= f;
        this.z *= f;
        this.w *= f;
        return this;
    }

    public Vector4f divide(Vector4f vector4f) {
        return new Vector4f(this.x / vector4f.x, this.y / vector4f.y, this.z / vector4f.z, this.w / vector4f.w);
    }

    public Vector4f divideLocal(Vector4f vector4f) {
        this.x /= vector4f.x;
        this.y /= vector4f.y;
        this.z /= vector4f.z;
        this.w /= vector4f.w;
        return this;
    }

    public Vector4f negate() {
        return new Vector4f(-this.x, -this.y, -this.z, -this.w);
    }

    public Vector4f negateLocal() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        this.w = -this.w;
        return this;
    }

    public Vector4f subtract(Vector4f vector4f) {
        return new Vector4f(this.x - vector4f.x, this.y - vector4f.y, this.z - vector4f.z, this.w - vector4f.w);
    }

    public Vector4f subtractLocal(Vector4f vector4f) {
        if (null == vector4f) {
            logger.warning("Provided vector is null, null returned.");
            return null;
        }
        this.x -= vector4f.x;
        this.y -= vector4f.y;
        this.z -= vector4f.z;
        this.w -= vector4f.w;
        return this;
    }

    public Vector4f subtract(Vector4f vector4f, Vector4f vector4f2) {
        if (vector4f2 == null) {
            vector4f2 = new Vector4f();
        }
        vector4f2.x = this.x - vector4f.x;
        vector4f2.y = this.y - vector4f.y;
        vector4f2.z = this.z - vector4f.z;
        vector4f2.w = this.w - vector4f.w;
        return vector4f2;
    }

    public Vector4f subtract(float f, float f2, float f3, float f4) {
        return new Vector4f(this.x - f, this.y - f2, this.z - f3, this.w - f4);
    }

    public Vector4f subtractLocal(float f, float f2, float f3, float f4) {
        this.x -= f;
        this.y -= f2;
        this.z -= f3;
        this.w -= f4;
        return this;
    }

    public Vector4f normalize() {
        float f = this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
        if (f != 1.0f && f != 0.0f) {
            f = 1.0f / FastMath.sqrt(f);
            return new Vector4f(this.x * f, this.y * f, this.z * f, this.w * f);
        }
        return this.clone();
    }

    public Vector4f normalizeLocal() {
        float f = this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
        if (f != 1.0f && f != 0.0f) {
            f = 1.0f / FastMath.sqrt(f);
            this.x *= f;
            this.y *= f;
            this.z *= f;
            this.w *= f;
        }
        return this;
    }

    public void maxLocal(Vector4f vector4f) {
        this.x = vector4f.x > this.x ? vector4f.x : this.x;
        this.y = vector4f.y > this.y ? vector4f.y : this.y;
        this.z = vector4f.z > this.z ? vector4f.z : this.z;
        this.w = vector4f.w > this.w ? vector4f.w : this.w;
    }

    public void minLocal(Vector4f vector4f) {
        this.x = vector4f.x < this.x ? vector4f.x : this.x;
        this.y = vector4f.y < this.y ? vector4f.y : this.y;
        this.z = vector4f.z < this.z ? vector4f.z : this.z;
        this.w = vector4f.w < this.w ? vector4f.w : this.w;
    }

    public Vector4f zero() {
        this.w = 0.0f;
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        return this;
    }

    public float angleBetween(Vector4f vector4f) {
        float f = this.dot(vector4f);
        float f2 = FastMath.acos(f);
        return f2;
    }

    public Vector4f interpolate(Vector4f vector4f, float f) {
        this.x = (1.0f - f) * this.x + f * vector4f.x;
        this.y = (1.0f - f) * this.y + f * vector4f.y;
        this.z = (1.0f - f) * this.z + f * vector4f.z;
        this.w = (1.0f - f) * this.w + f * vector4f.w;
        return this;
    }

    public Vector4f interpolate(Vector4f vector4f, Vector4f vector4f2, float f) {
        this.x = (1.0f - f) * vector4f.x + f * vector4f2.x;
        this.y = (1.0f - f) * vector4f.y + f * vector4f2.y;
        this.z = (1.0f - f) * vector4f.z + f * vector4f2.z;
        this.w = (1.0f - f) * vector4f.w + f * vector4f2.w;
        return this;
    }

    public static boolean isValidVector(Vector4f vector4f) {
        if (vector4f == null) {
            return false;
        }
        if (Float.isNaN(vector4f.x) || Float.isNaN(vector4f.y) || Float.isNaN(vector4f.z) || Float.isNaN(vector4f.w)) {
            return false;
        }
        return !Float.isInfinite(vector4f.x) && !Float.isInfinite(vector4f.y) && !Float.isInfinite(vector4f.z) && !Float.isInfinite(vector4f.w);
    }

    public Vector4f clone() {
        try {
            return (Vector4f)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }

    public float[] toArray(float[] fArray) {
        if (fArray == null) {
            fArray = new float[]{this.x, this.y, this.z, this.w};
        }
        return fArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Vector4f)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Vector4f vector4f = (Vector4f)object;
        if (Float.compare(this.x, vector4f.x) != 0) {
            return false;
        }
        if (Float.compare(this.y, vector4f.y) != 0) {
            return false;
        }
        if (Float.compare(this.z, vector4f.z) != 0) {
            return false;
        }
        return Float.compare(this.w, vector4f.w) == 0;
    }

    public int hashCode() {
        int n = 37;
        n += 37 * n + Float.floatToIntBits(this.x);
        n += 37 * n + Float.floatToIntBits(this.y);
        n += 37 * n + Float.floatToIntBits(this.z);
        n += 37 * n + Float.floatToIntBits(this.w);
        return n;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + ")";
    }

    public float getX() {
        return this.x;
    }

    public Vector4f setX(float f) {
        this.x = f;
        return this;
    }

    public float getY() {
        return this.y;
    }

    public Vector4f setY(float f) {
        this.y = f;
        return this;
    }

    public float getZ() {
        return this.z;
    }

    public Vector4f setZ(float f) {
        this.z = f;
        return this;
    }

    public float getW() {
        return this.w;
    }

    public Vector4f setW(float f) {
        this.w = f;
        return this;
    }

    public float get(int n) {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
            case 3: {
                return this.w;
            }
        }
        throw new IllegalArgumentException("index must be either 0, 1, 2 or 3");
    }

    public void set(int n, float f) {
        switch (n) {
            case 0: {
                this.x = f;
                return;
            }
            case 1: {
                this.y = f;
                return;
            }
            case 2: {
                this.z = f;
                return;
            }
            case 3: {
                this.w = f;
                return;
            }
        }
        throw new IllegalArgumentException("index must be either 0, 1, 2 or 3");
    }
}

