/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.math.curve;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import tazadum.engine.math.Vector3f;
import tazadum.engine.math.curve.Curve;

public class BezierCurve
implements Curve {
    private final List<Vector3f> nodes = new CopyOnWriteArrayList<Vector3f>();

    @Override
    public void add(Vector3f vector3f) {
        this.nodes.add(vector3f);
    }

    @Override
    public void remove(int n) {
        this.nodes.remove(this.nodes.get(n));
    }

    @Override
    public List<Vector3f> nodes() {
        return this.nodes;
    }

    @Override
    public Vector3f get(float f) {
        if (this.nodes.isEmpty()) {
            return new Vector3f();
        }
        if (f <= 0.0f) {
            return new Vector3f(this.nodes.get(0));
        }
        float f2 = this.length();
        if (f >= f2) {
            return new Vector3f(this.nodes.get(3 * (int)f2));
        }
        return this.calculate(f, f2);
    }

    private Vector3f calculate(float f, float f2) {
        float f3 = f - (float)((int)f);
        int n = 3 * (int)f;
        Vector3f vector3f = this.nodes.get(n + 0);
        Vector3f vector3f2 = this.nodes.get(n + 1);
        Vector3f vector3f3 = this.nodes.get(n + 2);
        Vector3f vector3f4 = this.nodes.get(n + 3);
        return this.segment(f3, vector3f, vector3f2, vector3f3, vector3f4);
    }

    private Vector3f segment(float f, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4) {
        float f2 = 1.0f - f;
        float f3 = f * f;
        float f4 = f2 * f2;
        float f5 = 3.0f * f4 * f;
        float f6 = 3.0f * f2 * f3;
        float f7 = f4 * f2;
        float f8 = f3 * f;
        Vector3f vector3f5 = new Vector3f();
        vector3f5.x = f7 * vector3f.x + f5 * vector3f2.x + f6 * vector3f3.x + f8 * vector3f4.x;
        vector3f5.y = f7 * vector3f.y + f5 * vector3f2.y + f6 * vector3f3.y + f8 * vector3f4.y;
        vector3f5.z = f7 * vector3f.z + f5 * vector3f2.z + f6 * vector3f3.z + f8 * vector3f4.z;
        return vector3f5;
    }

    @Override
    public float length() {
        return (int)Math.floor((this.nodes.size() - 1) / 3);
    }
}

