/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.parameter;

import javax.inject.Inject;
import tazadum.engine.configuration.ParameterManager;
import tazadum.engine.math.Vector2f;
import tazadum.engine.math.Vector3f;
import tazadum.engine.math.Vector4f;
import tazadum.engine.parameter.ConstantColorParameter;
import tazadum.engine.parameter.ConstantFloatParameter;
import tazadum.engine.parameter.Parameter;
import tazadum.engine.parameter.ParameterFactory;
import tazadum.engine.parameter.SplineVector3Parameter;
import tazadum.engine.parameter.Tween1fParameter;
import tazadum.engine.parameter.Tween2fParameter;
import tazadum.engine.parameter.Tween3fParameter;
import tazadum.engine.parameter.Tween4fParameter;

public class ParameterFactoryImpl
implements ParameterFactory {
    private final ParameterManager parameterManager;

    @Inject
    public ParameterFactoryImpl(ParameterManager parameterManager) {
        this.parameterManager = parameterManager;
    }

    @Override
    public Parameter<Float> tween1f(Object object, String string) {
        return this.parameterManager.getParameter(object, string, Tween1fParameter.class);
    }

    @Override
    public Parameter<Vector2f> tween2f(Object object, String string) {
        return this.parameterManager.getParameter(object, string, Tween2fParameter.class);
    }

    @Override
    public Parameter<Vector3f> tween3f(Object object, String string) {
        return this.parameterManager.getParameter(object, string, Tween3fParameter.class);
    }

    @Override
    public Parameter<Vector4f> tween4f(Object object, String string) {
        return this.parameterManager.getParameter(object, string, Tween4fParameter.class);
    }

    @Override
    public Parameter<Vector3f> spline(Object object, String string) {
        return this.parameterManager.getParameter(object, string, SplineVector3Parameter.class);
    }

    @Override
    public Parameter<Integer> constantColor(Object object, String string) {
        return this.parameterManager.getParameter(object, string, ConstantColorParameter.class);
    }

    @Override
    public Parameter<Float> constant1f(Object object, String string) {
        return this.parameterManager.getParameter(object, string, ConstantFloatParameter.class);
    }
}

