/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.rendering;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.media.opengl.GL;
import tazadum.engine.rendering.LifeCycle;
import tazadum.engine.rendering.LifeCycleManager;

public class LifeCycleManagerImpl
implements LifeCycleManager {
    private final List<LifeCycle> shaders = new CopyOnWriteArrayList<LifeCycle>();
    private boolean initialized;

    @Override
    public <T extends LifeCycle> T add(T t) {
        if (!this.shaders.contains(t)) {
            this.shaders.add(t);
            return t;
        }
        return t;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void onInit(GL gL) {
        this.initialized = true;
        for (LifeCycle lifeCycle : this.shaders) {
            lifeCycle.onInit(gL);
        }
    }

    @Override
    public void onDeinit(GL gL) {
        for (LifeCycle lifeCycle : this.shaders) {
            lifeCycle.onDeinit(gL);
        }
    }
}

