/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.rendering;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import tazadum.engine.asset.AssetManager;
import tazadum.engine.configuration.TimelineScene;
import tazadum.engine.math.Rectangle;
import tazadum.engine.rendering.RenderEngine;
import tazadum.engine.rendering.RenderStateManager;
import tazadum.engine.rendering.camera.Camera;
import tazadum.engine.rendering.camera.DefaultCamera;
import tazadum.engine.rendering.camera.DefaultOrthographicCamera;
import tazadum.engine.rendering.camera.OrthographicCamera;
import tazadum.engine.rendering.effect.Effect;
import tazadum.engine.rendering.effect.PostEffect;
import tazadum.engine.rendering.layout.NormalizedLayout;
import tazadum.engine.rendering.scenegraph.MeshNode;
import tazadum.engine.rendering.scenegraph.Node;
import tazadum.engine.rendering.scenegraph.Scene;
import tazadum.engine.rendering.scenegraph.SceneGraph;
import tazadum.engine.rendering.scenegraph.SceneGraphImpl;
import tazadum.engine.rendering.target.FBORenderTarget;
import tazadum.engine.rendering.target.RenderTarget;
import tazadum.engine.rendering.target.ScreenRenderTarget;

public class RenderEngineImpl
implements RenderEngine {
    private final RenderStateManager renderStateManager;
    private final AssetManager assetManager;
    private Camera camera;
    private final OrthographicCamera cameraOrtho;
    private final NormalizedLayout normalizedLayout;
    private final ScreenRenderTarget screenTarget;
    private final Set<Effect> effects = new HashSet<Effect>();
    private final Set<Scene> activeScenes = new HashSet<Scene>();
    private final Set<Scene> missingScenes = new HashSet<Scene>();
    private PostEffect postEffect;
    private RenderTarget postEffectTarget;
    private final SceneGraph sceneGraph;
    private final SceneGraph orthoGraph;
    private final int sceneGraphLayer = 2;
    private float ratio = 1.0f;
    private Rectangle rectangle;

    @Inject
    public RenderEngineImpl(AssetManager assetManager, RenderStateManager renderStateManager, NormalizedLayout normalizedLayout) {
        this.assetManager = assetManager;
        this.renderStateManager = renderStateManager;
        this.normalizedLayout = normalizedLayout;
        this.camera = new DefaultCamera(1.0f, 10000.0f, -1.0f, 1.0f, 1.0f, -1.0f);
        this.cameraOrtho = new DefaultOrthographicCamera(0.1f, 10000.0f, 0.0f, 320.0f, 240.0f, 0.0f);
        this.rectangle = new Rectangle(0.0f, 0.0f, 640.0f, 480.0f);
        this.screenTarget = new ScreenRenderTarget(this.rectangle);
        this.sceneGraph = new SceneGraphImpl();
        this.orthoGraph = new SceneGraphImpl();
    }

    public RenderStateManager getRenderStateManager() {
        return this.renderStateManager;
    }

    @Override
    public void configure(GL2 gL2, Rectangle rectangle) {
        this.rectangle = rectangle;
        gL2.glDepthRange((double)0.1f, 1000.0);
        this.ratio = rectangle.height / rectangle.width;
        this.camera = new DefaultCamera(1.0f, 10000.0f, -1.0f / this.ratio, 1.0f / this.ratio, 1.0f, -1.0f);
        this.screenTarget.setArea(rectangle);
        this.assetManager.load();
        float f = rectangle.x + rectangle.width;
        float f2 = rectangle.x;
        float f3 = rectangle.y + rectangle.height;
        float f4 = rectangle.y;
        this.cameraOrtho.configure(1.0f, 1000.0f, f, f2, f3, f4);
        this.cameraOrtho.update();
        if (this.postEffect != null && this.postEffect.requireFBO() && this.postEffectTarget == null) {
            FBORenderTarget fBORenderTarget = new FBORenderTarget((int)rectangle.width, (int)rectangle.height);
            fBORenderTarget.onInit((GL)gL2);
            this.postEffectTarget = fBORenderTarget;
        }
        this.normalizedLayout.set(rectangle);
    }

    @Override
    public Rectangle getArea() {
        return this.rectangle;
    }

    @Override
    public void setPostEffect(PostEffect postEffect) {
        this.postEffect = postEffect;
    }

    @Override
    public Camera getCamera() {
        return this.camera;
    }

    @Override
    public OrthographicCamera getOrthographicCamera() {
        return this.cameraOrtho;
    }

    @Override
    public SceneGraph getOrthoGraph() {
        return this.orthoGraph;
    }

    @Override
    public void render(GL2 gL2, float f, float f2, List<TimelineScene> list) {
        this.camera.update();
        this.startStopScenes(gL2, list);
        this.sceneGraph.calculateTransformations();
        for (Effect iterator : this.effects) {
            iterator.onPreRender(gL2, f, f2);
        }
        if (this.postEffect == null) {
            this.screenTarget.enable((GL)gL2);
        } else {
            this.postEffectTarget.enable((GL)gL2);
        }
        gL2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        gL2.glClear(16640);
        boolean bl = false;
        for (TimelineScene timelineScene : list) {
            if (!bl && timelineScene.getLayer() < 2) {
                this.sceneGraph.render(gL2, this.camera, null, false);
                bl = true;
            }
            float f3 = f - timelineScene.getInterval().from();
            float f4 = timelineScene.getInterval().alpha(f);
            timelineScene.getScene().onUpdate(gL2, f, f3, f2, f4);
        }
        for (Effect effect : this.effects) {
            effect.onPostRender(gL2, f, f2);
        }
        if (this.postEffect != null) {
            this.screenTarget.enable((GL)gL2);
            gL2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            gL2.glClear(16640);
            if (this.postEffect.requireFBO()) {
                int n = ((FBORenderTarget)this.postEffectTarget).getTextureId();
                this.postEffect.setTexture(0, n);
            }
            this.postEffect.onRender(gL2, f, f2);
        }
    }

    private void startStopScenes(GL2 gL2, List<TimelineScene> list) {
        this.missingScenes.clear();
        this.missingScenes.addAll(this.activeScenes);
        Node<MeshNode> node = this.sceneGraph.getWorld();
        for (TimelineScene object : list) {
            Scene scene = object.getScene();
            if (this.activeScenes.contains(scene)) {
                this.missingScenes.remove(scene);
                continue;
            }
            this.activeScenes.add(scene);
            scene.onStart(node, object.getInterval());
        }
        for (Scene scene : this.missingScenes) {
            scene.onStop(node);
            this.activeScenes.remove(scene);
        }
    }

    @Override
    public void addEffect(Effect effect) {
        this.effects.add(effect);
    }

    @Override
    public void removeEffect(Effect effect) {
        this.effects.remove(effect);
    }

    @Override
    public SceneGraph getSceneGraph() {
        return this.sceneGraph;
    }

    @Override
    public float getRatio() {
        return this.ratio;
    }
}

