/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.rendering.mesh;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL2;
import tazadum.engine.math.Box;
import tazadum.engine.rendering.mesh.Mesh;

public class MeshImpl
implements Mesh {
    private final FloatBuffer vertices;
    private final FloatBuffer normals;
    private final FloatBuffer textureCoords;
    private final IntBuffer indices;
    private final Box boundingBox;

    public MeshImpl(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3, IntBuffer intBuffer, Box box) {
        this.vertices = floatBuffer;
        this.normals = floatBuffer2;
        this.textureCoords = floatBuffer3;
        this.indices = intBuffer;
        this.boundingBox = box;
    }

    @Override
    public Box getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public IntBuffer getIndices() {
        return this.indices;
    }

    @Override
    public FloatBuffer getVertices() {
        return this.vertices;
    }

    @Override
    public FloatBuffer getNormals() {
        return this.normals;
    }

    public String toString() {
        return "Mesh [" + this.boundingBox + "]";
    }

    @Override
    public void draw(GL2 gL2) {
        this.indices.rewind();
        gL2.glDrawElements(4, this.indices.capacity(), 5125, (Buffer)this.indices);
    }

    @Override
    public FloatBuffer getTextureChoords() {
        return this.textureCoords;
    }
}

